/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser.xml;

import com.aspectran.core.context.rule.AppendRule;
import com.aspectran.core.context.rule.DescriptionRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.appender.RuleAppendHandler;
import com.aspectran.core.context.rule.appender.RuleAppender;
import com.aspectran.core.context.rule.assistant.ContextRuleAssistant;
import com.aspectran.core.context.rule.parser.xml.ActionNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.AspectAdviceInnerNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.AspectNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.AspectranDtdResolver;
import com.aspectran.core.context.rule.parser.xml.BeanNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.ChooseNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.EnvironmentNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.ExceptionInnerNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.InnerBeanNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.ItemNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.ResponseInnerNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.ScheduleNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.TemplateNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.TransletNodeletAdder;
import com.aspectran.core.util.ExceptionUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.nodelet.NodeletParser;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.InputSource;

public class AspectranNodeParser {
    private static final Log log = LogFactory.getLog(AspectranNodeParser.class);
    private final ContextRuleAssistant assistant;
    private final ActionNodeletAdder actionNodeletAdder;
    private final AspectAdviceInnerNodeletAdder aspectAdviceInnerNodeletAdder;
    private final AspectNodeletAdder aspectNodeletAdder;
    private final BeanNodeletAdder beanNodeletAdder;
    private final ChooseNodeletAdder chooseNodeletAdder;
    private final EnvironmentNodeletAdder environmentNodeletAdder;
    private final ExceptionInnerNodeletAdder exceptionInnerNodeletAdder;
    private final ItemNodeletAdder[] itemNodeletAdders;
    private final InnerBeanNodeletAdder[] innerBeanNodeletAdders;
    private final ResponseInnerNodeletAdder responseInnerNodeletAdder;
    private final ScheduleNodeletAdder scheduleNodeletAdder;
    private final TemplateNodeletAdder templateNodeletAdder;
    private final TransletNodeletAdder transletNodeletAdder;
    private final NodeletParser parser;

    public AspectranNodeParser(ContextRuleAssistant assistant) {
        this(assistant, true, true);
    }

    public AspectranNodeParser(ContextRuleAssistant assistant, boolean validating, boolean trackingLocation) {
        this.assistant = assistant;
        this.actionNodeletAdder = new ActionNodeletAdder();
        this.aspectAdviceInnerNodeletAdder = new AspectAdviceInnerNodeletAdder();
        this.aspectNodeletAdder = new AspectNodeletAdder();
        this.beanNodeletAdder = new BeanNodeletAdder();
        this.chooseNodeletAdder = new ChooseNodeletAdder();
        this.environmentNodeletAdder = new EnvironmentNodeletAdder();
        this.exceptionInnerNodeletAdder = new ExceptionInnerNodeletAdder();
        this.responseInnerNodeletAdder = new ResponseInnerNodeletAdder();
        this.scheduleNodeletAdder = new ScheduleNodeletAdder();
        this.templateNodeletAdder = new TemplateNodeletAdder();
        this.transletNodeletAdder = new TransletNodeletAdder();
        this.itemNodeletAdders = new ItemNodeletAdder[]{new ItemNodeletAdder(0), new ItemNodeletAdder(1), new ItemNodeletAdder(2)};
        this.innerBeanNodeletAdders = new InnerBeanNodeletAdder[]{null, new InnerBeanNodeletAdder(1), new InnerBeanNodeletAdder(2)};
        this.parser = new NodeletParser(this);
        this.parser.setValidating(validating);
        this.parser.setEntityResolver(new AspectranDtdResolver(validating));
        if (trackingLocation) {
            this.parser.trackingLocation();
        }
        this.addDescriptionNodelets();
        this.addSettingsNodelets();
        this.addTypeAliasNodelets();
        this.addEnvironmentNodelets();
        this.addAspectNodelets();
        this.addBeanNodelets();
        this.addScheduleNodelets();
        this.addTemplateNodelets();
        this.addTransletNodelets();
        this.addAppendNodelets();
    }

    public ContextRuleAssistant getAssistant() {
        return this.assistant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(RuleAppender ruleAppender) throws Exception {
        InputStream inputStream = null;
        try {
            ruleAppender.setNodeTracker(this.parser.getNodeTracker());
            inputStream = ruleAppender.getInputStream();
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(ruleAppender.getQualifiedName());
            this.parser.parse(inputSource);
        }
        catch (Exception e) {
            Throwable cause = ExceptionUtils.getRootCause(e);
            if (cause instanceof IllegalRuleException) {
                this.parsingFailed(cause.getMessage(), cause);
            } else {
                this.parsingFailed("Error parsing aspectran configuration", cause);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void parsingFailed(String message, Throwable cause) throws Exception {
        String detail = this.assistant.getRuleAppendHandler().getCurrentRuleAppender().getNodeTracker().getName() != null ? message + ": " + this.assistant.getRuleAppendHandler().getCurrentRuleAppender().getNodeTracker() + " on " + this.assistant.getRuleAppendHandler().getCurrentRuleAppender().getQualifiedName() : message + ": " + this.assistant.getRuleAppendHandler().getCurrentRuleAppender().getQualifiedName();
        log.error(detail);
        throw new Exception(detail, cause);
    }

    private void addDescriptionNodelets() {
        this.parser.setXpath("/aspectran/description");
        this.parser.addNodelet(attrs -> {
            String profile = (String)attrs.get("profile");
            String style = (String)attrs.get("style");
            DescriptionRule descriptionRule = DescriptionRule.newInstance(profile, style);
            this.parser.pushObject(descriptionRule);
        });
        this.parser.addNodeEndlet(text -> {
            DescriptionRule descriptionRule = (DescriptionRule)this.parser.popObject();
            descriptionRule.setContent(text);
            descriptionRule = this.assistant.profiling(descriptionRule, this.assistant.getAssistantLocal().getDescriptionRule());
            this.assistant.getAssistantLocal().setDescriptionRule(descriptionRule);
        });
    }

    private void addSettingsNodelets() {
        this.parser.setXpath("/aspectran/settings");
        this.parser.addNodeEndlet(text -> this.assistant.applySettings());
        this.parser.setXpath("/aspectran/settings/setting");
        this.parser.addNodelet(attrs -> {
            String name = (String)attrs.get("name");
            String value = (String)attrs.get("value");
            this.parser.pushObject(value);
            this.parser.pushObject(name);
        });
        this.parser.addNodeEndlet(text -> {
            String name = (String)this.parser.popObject();
            String value = (String)this.parser.popObject();
            if (value != null) {
                this.assistant.putSetting(name, value);
            } else if (text != null) {
                this.assistant.putSetting(name, text);
            }
        });
    }

    private void addTypeAliasNodelets() {
        this.parser.setXpath("/aspectran/typeAliases/typeAlias");
        this.parser.addNodelet(attrs -> {
            String alias = (String)attrs.get("alias");
            String type = (String)attrs.get("type");
            this.parser.pushObject(type);
            this.parser.pushObject(alias);
        });
        this.parser.addNodeEndlet(text -> {
            String alias = (String)this.parser.popObject();
            String type = (String)this.parser.popObject();
            if (type != null) {
                this.assistant.addTypeAlias(alias, type);
            } else if (text != null) {
                this.assistant.addTypeAlias(alias, text);
            }
        });
    }

    private void addEnvironmentNodelets() {
        this.parser.addNodelet("/aspectran", this.environmentNodeletAdder);
    }

    private void addAspectNodelets() {
        this.parser.addNodelet("/aspectran", this.aspectNodeletAdder);
    }

    private void addBeanNodelets() {
        this.parser.addNodelet("/aspectran", this.beanNodeletAdder);
    }

    private void addScheduleNodelets() {
        this.parser.addNodelet("/aspectran", this.scheduleNodeletAdder);
    }

    private void addTemplateNodelets() {
        this.parser.addNodelet("/aspectran", this.templateNodeletAdder);
    }

    private void addTransletNodelets() {
        this.parser.addNodelet("/aspectran", this.transletNodeletAdder);
    }

    private void addAppendNodelets() {
        this.parser.setXpath("/aspectran/append");
        this.parser.addNodelet(attrs -> {
            String file = (String)attrs.get("file");
            String resource = (String)attrs.get("resource");
            String url = (String)attrs.get("url");
            String format = (String)attrs.get("format");
            String profile = (String)attrs.get("profile");
            RuleAppendHandler appendHandler = this.assistant.getRuleAppendHandler();
            if (appendHandler != null) {
                AppendRule appendRule = AppendRule.newInstance(file, resource, url, format, profile);
                appendHandler.pending(appendRule);
            }
        });
    }

    void addActionNodelets() {
        this.parser.addNodelet(this.actionNodeletAdder);
    }

    void addNestedActionNodelets() {
        String xpath = this.parser.getXpath();
        this.parser.addNodelet(this.actionNodeletAdder);
        this.parser.addNodelet(this.chooseNodeletAdder);
        this.parser.setXpath(xpath + "/choose/when");
        this.parser.addNodelet(this.chooseNodeletAdder);
        this.parser.setXpath(xpath + "/choose/otherwise");
        this.parser.addNodelet(this.chooseNodeletAdder);
        this.parser.setXpath(xpath + "/choose/when/choose/when/choose");
        this.parser.addNodelet(attrs -> {
            throw new IllegalRuleException("The <choose> element can only be nested up to 2 times");
        });
        this.parser.setXpath(xpath + "/choose/when/choose/otherwise/choose");
        this.parser.addNodelet(attrs -> {
            throw new IllegalRuleException("The <choose> element can only be nested up to 2 times");
        });
        this.parser.setXpath(xpath + "/choose/otherwise/choose/when/choose");
        this.parser.addNodelet(attrs -> {
            throw new IllegalRuleException("The <choose> element can only be nested up to 2 times");
        });
        this.parser.setXpath(xpath + "/choose/otherwise/choose/otherwise/choose");
        this.parser.addNodelet(attrs -> {
            throw new IllegalRuleException("The <choose> element can only be nested up to 2 times");
        });
        this.parser.setXpath(xpath);
    }

    void addAspectAdviceInnerNodelets() {
        this.parser.addNodelet(this.aspectAdviceInnerNodeletAdder);
    }

    void addExceptionInnerNodelets() {
        this.parser.addNodelet(this.exceptionInnerNodeletAdder);
    }

    void addResponseInnerNodelets() {
        this.parser.addNodelet(this.responseInnerNodeletAdder);
    }

    void addItemNodelets() {
        this.addItemNodelets(0);
    }

    void addItemNodelets(int depth) {
        this.parser.addNodelet(this.itemNodeletAdders[depth]);
    }

    void addInnerBeanNodelets(int depth) {
        if (depth < this.innerBeanNodeletAdders.length - 1) {
            this.parser.addNodelet(this.innerBeanNodeletAdders[depth + 1]);
        }
    }

    int getMaxInnerBeans() {
        return this.innerBeanNodeletAdders.length - 1;
    }
}

