/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.scheduler.support;

import com.aspectran.core.component.bean.ablility.FactoryBean;
import com.aspectran.core.component.bean.ablility.InitializableBean;
import java.util.Properties;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzSchedulerFactoryBean
implements InitializableBean,
FactoryBean<Scheduler> {
    private String schedulerName;
    private Properties quartzProperties;
    private boolean exposeSchedulerInRepository;
    private Scheduler scheduler;

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public void setQuartzProperties(Properties quartzProperties) {
        this.quartzProperties = quartzProperties;
    }

    public void setExposeSchedulerInRepository(boolean exposeSchedulerInRepository) {
        this.exposeSchedulerInRepository = exposeSchedulerInRepository;
    }

    protected Scheduler createScheduler() throws SchedulerException {
        SchedulerRepository repository;
        Scheduler existingScheduler;
        String schedulerName;
        Properties props = this.quartzProperties != null ? new Properties(this.quartzProperties) : new Properties();
        if (this.schedulerName != null) {
            props.put("org.quartz.scheduler.instanceName", this.schedulerName);
        }
        if ((schedulerName = props.getProperty("org.quartz.scheduler.instanceName")) != null && (existingScheduler = (repository = SchedulerRepository.getInstance()).lookup(schedulerName)) != null) {
            throw new IllegalStateException("Active Scheduler of name '" + schedulerName + "' already registered in Quartz SchedulerRepository. Cannot create a new Aspectran-managed Scheduler of the same name!");
        }
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(props);
        Scheduler newScheduler = schedulerFactory.getScheduler();
        if (!this.exposeSchedulerInRepository) {
            SchedulerRepository.getInstance().remove(newScheduler.getSchedulerName());
        }
        return newScheduler;
    }

    @Override
    public void initialize() throws Exception {
        this.scheduler = this.createScheduler();
    }

    @Override
    public Scheduler getObject() {
        return this.scheduler;
    }
}

