/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.support.i18n.locale;

import com.aspectran.core.activity.Translet;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.support.i18n.locale.AbstractLocaleResolver;
import java.util.Locale;
import java.util.TimeZone;

public class SessionLocaleResolver
extends AbstractLocaleResolver {
    public static final String LOCALE_SESSION_ATTR_NAME = SessionLocaleResolver.class.getName() + ".LOCALE";
    public static final String TIME_ZONE_SESSION_ATTR_NAME = SessionLocaleResolver.class.getName() + ".TIME_ZONE";

    @Override
    public Locale resolveLocale(Translet translet) {
        Locale locale;
        SessionAdapter sessionAdapter = translet.getSessionAdapter();
        if (sessionAdapter != null && (locale = (Locale)sessionAdapter.getAttribute(LOCALE_SESSION_ATTR_NAME)) != null) {
            super.setLocale(translet, locale);
            return locale;
        }
        return this.resolveDefaultLocale(translet);
    }

    @Override
    public TimeZone resolveTimeZone(Translet translet) {
        TimeZone timeZone;
        SessionAdapter sessionAdapter = translet.getSessionAdapter();
        if (sessionAdapter != null && (timeZone = (TimeZone)sessionAdapter.getAttribute(TIME_ZONE_SESSION_ATTR_NAME)) != null) {
            super.setTimeZone(translet, timeZone);
            return timeZone;
        }
        return this.resolveDefaultTimeZone(translet);
    }

    @Override
    public void setLocale(Translet translet, Locale locale) {
        super.setLocale(translet, locale);
        SessionAdapter sessionAdapter = translet.getSessionAdapter();
        if (sessionAdapter != null) {
            sessionAdapter.setAttribute(LOCALE_SESSION_ATTR_NAME, locale);
        }
    }

    @Override
    public void setTimeZone(Translet translet, TimeZone timeZone) {
        super.setTimeZone(translet, timeZone);
        SessionAdapter sessionAdapter = translet.getSessionAdapter();
        if (sessionAdapter != null) {
            sessionAdapter.setAttribute(TIME_ZONE_SESSION_ATTR_NAME, timeZone);
        }
    }
}

