/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.lang.Nullable;
import com.aspectran.core.util.ExceptionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.security.AccessController;

public abstract class ClassUtils {
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String CLASS_FILE_SUFFIX = ".class";

    public static <T> T createInstance(Class<T> cls) {
        Constructor<T> ctor;
        try {
            ctor = ClassUtils.findConstructor(cls, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + cls.getName() + " has no default (no arg) constructor");
        }
        try {
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionUtils.unwrapAndThrowAsIAE(e, "Unable to instantiate class " + cls.getName() + ": " + e.getMessage());
        }
    }

    public static <T> T createInstance(Class<T> cls, Object ... args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        return ClassUtils.createInstance(cls, args, argTypes);
    }

    public static <T> T createInstance(Class<T> cls, Object[] args, Class<?>[] argTypes) {
        Constructor<T> ctor;
        try {
            ctor = ClassUtils.findConstructor(cls, argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + cls.getName() + " has no constructor which can accept the given arguments");
        }
        try {
            return ctor.newInstance(args);
        }
        catch (Exception e) {
            throw ExceptionUtils.unwrapAndThrowAsIAE(e, "Unable to instantiate class " + cls.getName() + ", problem: " + e.getMessage());
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> cls, Class<?> ... argTypes) throws NoSuchMethodException {
        Constructor<T> ctor;
        try {
            ctor = cls.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to find constructor of class " + cls.getName() + ", problem: " + e.getMessage(), ExceptionUtils.getRootCause(e));
        }
        if (!Modifier.isPublic(ctor.getModifiers())) {
            throw new IllegalArgumentException("Constructor for " + cls.getName() + " is not accessible (non-public?): not allowed to try modify access via Reflection: can not instantiate type");
        }
        return ctor;
    }

    public static boolean isVisible(Class<?> clazz, ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        try {
            if (clazz.getClassLoader() == classLoader) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return ClassUtils.isLoadable(clazz, classLoader);
    }

    private static boolean isLoadable(Class<?> clazz, ClassLoader classLoader) {
        try {
            return clazz == classLoader.loadClass(clazz.getName());
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static ClassLoader getDefaultClassLoader() {
        if (System.getSecurityManager() == null) {
            ClassLoader cl = null;
            try {
                cl = Thread.currentThread().getContextClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (cl == null) {
                cl = ClassUtils.class.getClassLoader();
            }
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            return cl;
        }
        return AccessController.doPrivileged(() -> {
            ClassLoader cl = null;
            try {
                cl = Thread.currentThread().getContextClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (cl == null) {
                cl = ClassUtils.class.getClassLoader();
            }
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            return cl;
        });
    }

    @Nullable
    public static ClassLoader overrideThreadContextClassLoader(@Nullable ClassLoader classLoaderToUse) {
        if (System.getSecurityManager() == null) {
            Thread currentThread = Thread.currentThread();
            ClassLoader threadContextClassLoader = currentThread.getContextClassLoader();
            if (classLoaderToUse != null && !classLoaderToUse.equals(threadContextClassLoader)) {
                currentThread.setContextClassLoader(classLoaderToUse);
                return threadContextClassLoader;
            }
            return null;
        }
        return AccessController.doPrivileged(() -> {
            Thread currentThread = Thread.currentThread();
            ClassLoader threadContextClassLoader = currentThread.getContextClassLoader();
            if (classLoaderToUse != null && !classLoaderToUse.equals(threadContextClassLoader)) {
                currentThread.setContextClassLoader(classLoaderToUse);
                return threadContextClassLoader;
            }
            return null;
        });
    }

    public static void restoreThreadContextClassLoader(@Nullable ClassLoader classLoader) {
        if (classLoader != null) {
            if (System.getSecurityManager() == null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            } else {
                AccessController.doPrivileged(() -> {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                });
            }
        }
    }
}

