/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.security;

import com.aspectran.core.util.PBEncryptionUtils;
import com.aspectran.core.util.apon.AponReader;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.security.InvalidPBTokenException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class PBTokenIssuer {
    public String createToken(Parameters payload) {
        if (payload == null) {
            throw new IllegalArgumentException("payload must not be null");
        }
        return this.encode(PBEncryptionUtils.encrypt(payload.toString()));
    }

    public <T extends Parameters> T parseToken(String token) throws InvalidPBTokenException {
        return this.parseToken(token, null);
    }

    public <T extends Parameters> T parseToken(String token, Class<T> payloadType) throws InvalidPBTokenException {
        if (token == null) {
            throw new IllegalArgumentException("token must not be null");
        }
        try {
            String payload = PBEncryptionUtils.decrypt(this.decode(token));
            if (payloadType != null) {
                return (T)AponReader.parse(payload, payloadType);
            }
            return (T)AponReader.parse(payload);
        }
        catch (IOException e) {
            throw new InvalidPBTokenException(token, e);
        }
    }

    protected String encode(String text) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(text.getBytes(StandardCharsets.UTF_8));
    }

    protected String decode(String text) {
        byte[] bytes = Base64.getUrlDecoder().decode(text.getBytes(StandardCharsets.UTF_8));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String getToken(Parameters payload) {
        return new PBTokenIssuer().createToken(payload);
    }

    public static <T extends Parameters> T getPayload(String token) throws InvalidPBTokenException {
        return new PBTokenIssuer().parseToken(token);
    }

    public static <T extends Parameters> T getPayload(String token, Class<T> payloadType) throws InvalidPBTokenException {
        return new PBTokenIssuer().parseToken(token, payloadType);
    }
}

