/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.security;

import com.aspectran.core.util.PBEncryptionUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.apon.AponReader;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.security.ExpiredPBTokenException;
import com.aspectran.core.util.security.InvalidPBTokenException;
import com.aspectran.core.util.security.PBTokenIssuer;

public class TimeLimitedPBTokenIssuer
extends PBTokenIssuer {
    private static final String PAYLOAD_SEPARATOR = "_";
    private static final long DEFAULT_EXPIRATION_TIME = 30000L;
    private final long expirationTime;

    public TimeLimitedPBTokenIssuer() {
        this(30000L);
    }

    public TimeLimitedPBTokenIssuer(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Override
    public String createToken(Parameters payload) {
        long time = System.currentTimeMillis() + this.expirationTime;
        String encodedTime = this.encode(PBEncryptionUtils.encrypt(Long.toString(time)));
        if (payload != null) {
            String combined = encodedTime + PAYLOAD_SEPARATOR + this.encode(PBEncryptionUtils.encrypt(payload.toString()));
            return this.encode(combined);
        }
        return encodedTime;
    }

    @Override
    public <T extends Parameters> T parseToken(String token) throws InvalidPBTokenException {
        return this.parseToken(token, null);
    }

    @Override
    public <T extends Parameters> T parseToken(String token, Class<T> payloadType) throws InvalidPBTokenException {
        String payload;
        long time;
        block10: {
            if (token == null) {
                throw new IllegalArgumentException("token must not be null");
            }
            try {
                String[] arr = StringUtils.split(this.decode(token), PAYLOAD_SEPARATOR);
                if (arr.length == 2) {
                    time = Long.parseLong(PBEncryptionUtils.decrypt(this.decode(arr[0])));
                    payload = PBEncryptionUtils.decrypt(this.decode(arr[1]));
                    break block10;
                }
                if (arr.length == 1) {
                    time = Long.parseLong(PBEncryptionUtils.decrypt(arr[0]));
                    payload = null;
                    break block10;
                }
                throw new InvalidPBTokenException(token);
            }
            catch (Exception e) {
                throw new InvalidPBTokenException(token, e);
            }
        }
        if (time < System.currentTimeMillis()) {
            throw new ExpiredPBTokenException(token);
        }
        if (payload != null) {
            try {
                if (payloadType != null) {
                    return (T)AponReader.parse(payload, payloadType);
                }
                return (T)AponReader.parse(payload);
            }
            catch (Exception e) {
                throw new InvalidPBTokenException(token, e);
            }
        }
        return null;
    }

    public static String getToken(Parameters payload) {
        return new TimeLimitedPBTokenIssuer().createToken(payload);
    }

    public static <T extends Parameters> T getPayload(String token) throws InvalidPBTokenException {
        return new TimeLimitedPBTokenIssuer().parseToken(token);
    }

    public static <T extends Parameters> T getPayload(String token, Class<T> payloadType) throws InvalidPBTokenException {
        return new TimeLimitedPBTokenIssuer().parseToken(token, payloadType);
    }

    public static String getToken() {
        return new TimeLimitedPBTokenIssuer().createToken(null);
    }

    public static void validate(String token) throws InvalidPBTokenException {
        new TimeLimitedPBTokenIssuer().parseToken(token, null);
    }
}

