/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.env.Environment;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.util.ExceptionUtils;

public abstract class AbstractActivity
implements Activity {
    private final ActivityContext context;
    private Activity parentActivity;
    private SessionAdapter sessionAdapter;
    private RequestAdapter requestAdapter;
    private ResponseAdapter responseAdapter;
    private Throwable raisedException;

    protected AbstractActivity(ActivityContext context) {
        this.context = context;
    }

    @Override
    public ActivityContext getActivityContext() {
        return this.context;
    }

    @Override
    public Environment getEnvironment() {
        return this.context.getEnvironment();
    }

    protected Activity getCurrentActivity() {
        return this.context.getCurrentActivity();
    }

    protected void saveCurrentActivity() {
        if (this.context.hasCurrentActivity()) {
            this.parentActivity = this.context.getCurrentActivity();
        }
        this.context.setCurrentActivity(this);
    }

    protected void removeCurrentActivity() {
        if (this.parentActivity != null) {
            this.context.setCurrentActivity(this.parentActivity);
        } else {
            this.context.removeCurrentActivity();
        }
    }

    protected <V extends Activity> V getParentActivity() {
        return (V)this.parentActivity;
    }

    protected boolean hasParentActivity() {
        return this.parentActivity != null;
    }

    @Override
    public ApplicationAdapter getApplicationAdapter() {
        return this.context.getApplicationAdapter();
    }

    @Override
    public SessionAdapter getSessionAdapter() {
        return this.sessionAdapter;
    }

    protected void setSessionAdapter(SessionAdapter sessionAdapter) {
        this.sessionAdapter = sessionAdapter;
    }

    @Override
    public RequestAdapter getRequestAdapter() {
        return this.requestAdapter;
    }

    protected void setRequestAdapter(RequestAdapter requestAdapter) {
        this.requestAdapter = requestAdapter;
    }

    @Override
    public ResponseAdapter getResponseAdapter() {
        return this.responseAdapter;
    }

    protected void setResponseAdapter(ResponseAdapter responseAdapter) {
        this.responseAdapter = responseAdapter;
    }

    @Override
    public boolean isExceptionRaised() {
        return this.raisedException != null;
    }

    @Override
    public Throwable getRaisedException() {
        return this.raisedException;
    }

    @Override
    public Throwable getRootCauseOfRaisedException() {
        return ExceptionUtils.getRootCause(this.raisedException);
    }

    @Override
    public void setRaisedException(Throwable raisedException) {
        if (this.raisedException == null) {
            this.raisedException = raisedException;
        }
    }

    @Override
    public void clearRaisedException() {
        this.raisedException = null;
    }

    @Override
    public <V> V getBean(String id) {
        return this.context.getBeanRegistry().getBean(id);
    }

    @Override
    public <V> V getBean(Class<V> type) {
        return this.context.getBeanRegistry().getBean(type);
    }

    @Override
    public <V> V getBean(Class<V> type, String id) {
        return this.context.getBeanRegistry().getBean(type, id);
    }

    @Override
    public <V> V getPrototypeScopeBean(BeanRule beanRule) {
        return this.context.getBeanRegistry().getPrototypeScopeBean(beanRule);
    }

    @Override
    public boolean containsBean(String id) {
        return this.context.getBeanRegistry().containsBean(id);
    }

    @Override
    public boolean containsBean(Class<?> type) {
        return this.context.getBeanRegistry().containsBean(type);
    }

    @Override
    public boolean containsBean(Class<?> type, String id) {
        return this.context.getBeanRegistry().containsBean(type, id);
    }

    @Override
    public void terminate() throws ActivityTerminatedException {
        this.terminate("Terminated by user code");
    }

    @Override
    public void terminate(String cause) throws ActivityTerminatedException {
        throw new ActivityTerminatedException(cause);
    }
}

