/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;

public class FormattingContext {
    private static final Logger logger = LoggerFactory.getLogger(FormattingContext.class);
    private static final int MAX_INDENT_SIZE = 8;
    private static final String FORMAT_INDENT_TAB = "format.indentTab";
    private static final String FORMAT_INDENT_SIZE = "format.indentSize";
    private static final String FORMAT_DATE_FORMAT = "format.dateFormat";
    private static final String FORMAT_DATETIME_FORMAT = "format.dateTimeFormat";
    private static final String FORMAT_NULL_WRITABLE = "format.nullWritable";
    private boolean pretty;
    private int indentSize;
    private boolean indentTab;
    private String dateFormat;
    private String dateTimeFormat;
    private Boolean nullWritable;

    public boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = indentSize;
    }

    public void setIndentTab(boolean indentTab) {
        this.indentTab = indentTab;
    }

    public String makeIndentString() {
        if (this.pretty) {
            if (this.indentTab) {
                return "\t";
            }
            if (this.indentSize > 0) {
                return StringUtils.repeat(' ', this.indentSize);
            }
            return "";
        }
        return null;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public Boolean getNullWritable() {
        return this.nullWritable;
    }

    public void setNullWritable(Boolean nullWritable) {
        this.nullWritable = nullWritable;
    }

    public static FormattingContext parse(Activity activity) {
        String indentStyle = (String)activity.getSetting(FORMAT_INDENT_TAB);
        String indentSize = (String)activity.getSetting(FORMAT_INDENT_SIZE);
        String dateFormat = (String)activity.getSetting(FORMAT_DATE_FORMAT);
        String dateTimeFormat = (String)activity.getSetting(FORMAT_DATETIME_FORMAT);
        Boolean nullWritable = BooleanUtils.toNullableBooleanObject((String)activity.getSetting(FORMAT_NULL_WRITABLE));
        FormattingContext formattingContext = new FormattingContext();
        if ("tab".equalsIgnoreCase(indentStyle)) {
            formattingContext.setPretty(true);
            formattingContext.setIndentTab(true);
        } else {
            int size = FormattingContext.parseIndentSize(indentSize);
            if (size > 0) {
                formattingContext.setPretty(true);
                formattingContext.setIndentSize(size);
            }
        }
        if (!StringUtils.isEmpty(dateFormat)) {
            formattingContext.setDateFormat(dateFormat);
        }
        if (!StringUtils.isEmpty(dateTimeFormat)) {
            formattingContext.setDateTimeFormat(dateTimeFormat);
        }
        if (nullWritable != null) {
            formattingContext.setNullWritable(nullWritable);
        }
        return formattingContext;
    }

    private static int parseIndentSize(String indentSize) {
        try {
            int size = Integer.parseInt(indentSize);
            if (size > 8) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Indent size should be less than 8");
                }
                size = 8;
            }
            return size;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

