/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.result;

import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.process.result.ActionResult;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.process.result.ResultValueMap;
import com.aspectran.core.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.ListIterator;

public class ContentResult
extends ArrayList<ActionResult> {
    private static final long serialVersionUID = 7394299260107452305L;
    private final ProcessResult parent;
    private String name;
    private boolean explicit;

    public ContentResult(ProcessResult parent) {
        this(parent, 5);
    }

    public ContentResult(ProcessResult parent, int initialCapacity) {
        super(initialCapacity);
        this.parent = parent;
        if (parent != null) {
            parent.addContentResult(this);
            this.setExplicit(parent.isExplicit());
        }
    }

    public ProcessResult getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public void setExplicit(boolean explicit) {
        this.explicit = explicit;
    }

    public ActionResult getActionResult(String actionId) {
        if (actionId == null) {
            return null;
        }
        ListIterator iter = this.listIterator(this.size());
        while (iter.hasPrevious()) {
            ActionResult actionResult = (ActionResult)iter.previous();
            if (!actionId.equals(actionResult.getActionId())) continue;
            return actionResult;
        }
        return null;
    }

    public void addActionResult(ActionResult actionResult) {
        ActionResult existing = this.getActionResult(actionResult.getActionId());
        if (existing != null && existing.getResultValue() instanceof ResultValueMap && actionResult.getResultValue() instanceof ResultValueMap) {
            ResultValueMap resultValueMap = (ResultValueMap)existing.getResultValue();
            resultValueMap.putAll((ResultValueMap)actionResult.getResultValue());
        } else {
            this.add(actionResult);
        }
    }

    public void addActionResult(Executable action, Object resultValue) {
        if (action == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        ActionResult actionResult = new ActionResult();
        actionResult.setResultValue(action.getActionId(), resultValue);
        this.addActionResult(actionResult);
    }

    public void addActionResult(Executable parentAction, ProcessResult processResult) {
        if (parentAction == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        if (processResult == null) {
            throw new IllegalArgumentException("processResult must not be null");
        }
        for (ContentResult contentResult : processResult) {
            for (ActionResult actionResult : contentResult) {
                if (actionResult.getActionId() == null) continue;
                Object actionId = parentAction.getActionId() != null ? parentAction.getActionId() + "." + actionResult.getActionId() : actionResult.getActionId();
                ActionResult newActionResult = new ActionResult();
                newActionResult.setResultValue((String)actionId, actionResult.getResultValue());
                this.addActionResult(newActionResult);
            }
        }
    }

    public String[] getActionIds() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (ActionResult actionResult : this) {
            if (actionResult.getActionId() == null) continue;
            set.add(actionResult.getActionId());
        }
        return set.toArray(new String[0]);
    }

    @Override
    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("name", this.name);
        tsb.append("actionResults", this);
        return tsb.toString();
    }
}

