/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.dispatch;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.result.ActionResult;
import com.aspectran.core.activity.process.result.ContentResult;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.ResponseException;
import com.aspectran.core.activity.response.dispatch.DispatchResponseException;
import com.aspectran.core.activity.response.dispatch.ViewDispatcher;
import com.aspectran.core.activity.response.dispatch.ViewDispatcherException;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.context.rule.DispatchRule;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DispatchResponse
implements Response {
    private static final Logger logger = LoggerFactory.getLogger(DispatchResponse.class);
    private static final Map<String, ViewDispatcher> cache = new ConcurrentHashMap<String, ViewDispatcher>();
    private final DispatchRule dispatchRule;

    public DispatchResponse(DispatchRule dispatchRule) {
        this.dispatchRule = dispatchRule;
    }

    @Override
    public void commit(Activity activity) throws ResponseException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Response " + this.dispatchRule);
            }
            ViewDispatcher viewDispatcher = this.getViewDispatcher(activity);
            viewDispatcher.dispatch(activity, this.dispatchRule);
        }
        catch (Exception e) {
            throw new DispatchResponseException(this.dispatchRule, (Throwable)e);
        }
    }

    public DispatchRule getDispatchRule() {
        return this.dispatchRule;
    }

    @Override
    public ResponseType getResponseType() {
        return DispatchRule.RESPONSE_TYPE;
    }

    @Override
    public String getContentType() {
        return this.dispatchRule.getContentType();
    }

    @Override
    public Response replicate() {
        return new DispatchResponse(this.dispatchRule.replicate());
    }

    private ViewDispatcher getViewDispatcher(Activity activity) throws ViewDispatcherException {
        if (this.dispatchRule.getViewDispatcher() != null) {
            return this.dispatchRule.getViewDispatcher();
        }
        try {
            String dispatcherName;
            if (this.dispatchRule.getDispatcherName() != null) {
                dispatcherName = this.dispatchRule.getDispatcherName();
            } else {
                dispatcherName = (String)activity.getSetting("viewDispatcher");
                if (dispatcherName == null) {
                    throw new IllegalArgumentException("Could not find the 'viewDispatcher' setting in the translet");
                }
            }
            ViewDispatcher viewDispatcher = cache.get(dispatcherName);
            if (viewDispatcher == null) {
                ViewDispatcher existing;
                if (dispatcherName.startsWith("class:")) {
                    String dispatcherClassName = dispatcherName.substring("class:".length());
                    Class<?> dispatcherClass = activity.getApplicationAdapter().getClassLoader().loadClass(dispatcherClassName);
                    viewDispatcher = (ViewDispatcher)activity.getBean(dispatcherClass);
                } else {
                    viewDispatcher = (ViewDispatcher)activity.getBean(dispatcherName);
                }
                if (viewDispatcher == null) {
                    throw new IllegalArgumentException("No bean named '" + dispatcherName + "' is defined");
                }
                if (viewDispatcher.isSingleton() && (existing = cache.putIfAbsent(dispatcherName, viewDispatcher)) != null) {
                    viewDispatcher = existing;
                }
            }
            return viewDispatcher;
        }
        catch (Exception e) {
            throw new ViewDispatcherException("Unable to determine ViewDispatcher", e);
        }
    }

    public String toString() {
        return this.dispatchRule.toString();
    }

    public static void saveAttributes(RequestAdapter requestAdapter, ProcessResult processResult) {
        if (processResult != null) {
            for (ContentResult contentResult : processResult) {
                for (ActionResult actionResult : contentResult) {
                    Object actionResultValue = actionResult.getResultValue();
                    if (actionResultValue instanceof ProcessResult) {
                        DispatchResponse.saveAttributes(requestAdapter, (ProcessResult)actionResultValue);
                        continue;
                    }
                    String actionId = actionResult.getActionId();
                    if (actionId != null) {
                        requestAdapter.setAttribute(actionId, actionResultValue);
                        continue;
                    }
                    if (!(actionResultValue instanceof Map)) continue;
                    for (Map.Entry entry : ((Map)actionResultValue).entrySet()) {
                        String name = entry.getKey().toString();
                        Object value = entry.getValue();
                        requestAdapter.setAttribute(name, value);
                    }
                }
            }
        }
    }
}

