/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.result.ActionResult;
import com.aspectran.core.activity.process.result.ContentResult;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.TemplateRule;
import com.aspectran.core.context.rule.TransformRule;
import java.io.Writer;

public class TextTransformResponse
extends TransformResponse {
    private final String contentType;
    private final String encoding;
    private final String templateId;
    private final TemplateRule templateRule;

    public TextTransformResponse(TransformRule transformRule) {
        super(transformRule);
        this.contentType = transformRule.getContentType();
        this.encoding = transformRule.getEncoding();
        this.templateId = transformRule.getTemplateId();
        this.templateRule = transformRule.getTemplateRule();
    }

    @Override
    protected void transform(Activity activity) throws Exception {
        String encoding;
        ResponseAdapter responseAdapter = activity.getResponseAdapter();
        if (this.encoding != null) {
            responseAdapter.setEncoding(this.encoding);
        } else if (responseAdapter.getEncoding() == null && (encoding = activity.getTranslet().getIntendedResponseEncoding()) != null) {
            responseAdapter.setEncoding(encoding);
        }
        if (this.contentType != null) {
            responseAdapter.setContentType(this.contentType);
        }
        Writer writer = responseAdapter.getWriter();
        if (this.templateId != null) {
            activity.getActivityContext().getTemplateRenderer().render(this.templateId, activity);
        } else if (this.templateRule != null) {
            activity.getActivityContext().getTemplateRenderer().render(this.templateRule, activity);
        } else {
            ProcessResult processResult = activity.getProcessResult();
            if (processResult != null) {
                int chunks = 0;
                for (ContentResult contentResult : processResult) {
                    for (ActionResult actionResult : contentResult) {
                        Object resultValue = actionResult.getResultValue();
                        if (resultValue == null) continue;
                        if (chunks++ > 0) {
                            writer.write(System.lineSeparator());
                        }
                        writer.write(resultValue.toString());
                    }
                }
            }
        }
    }

    @Override
    public Response replicate() {
        return new TextTransformResponse(this.getTransformRule().replicate());
    }
}

