/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform.json;

import com.aspectran.core.activity.process.result.ActionResult;
import com.aspectran.core.activity.process.result.ContentResult;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.util.Assert;
import com.aspectran.core.util.json.JsonWriter;
import java.io.IOException;
import java.io.Writer;

public class ContentsJsonWriter
extends JsonWriter {
    public ContentsJsonWriter(Writer writer) {
        super(writer);
    }

    @Override
    public <T extends JsonWriter> T write(Object object) throws IOException {
        if (object instanceof ProcessResult) {
            this.write((ProcessResult)object);
        } else {
            super.write(object);
        }
        return (T)this;
    }

    public void write(ProcessResult processResult) throws IOException {
        Assert.notNull((Object)processResult, "processResult must not be null");
        if (processResult.getName() != null) {
            this.beginObject();
            this.writeName(processResult.getName());
        }
        if (processResult.isEmpty()) {
            this.writeNull(processResult.getName() == null);
        } else if (processResult.size() == 1) {
            this.write((ContentResult)processResult.get(0));
        } else {
            this.beginArray();
            for (ContentResult contentResult : processResult) {
                this.write(contentResult);
            }
            this.endArray();
        }
        if (processResult.getName() != null) {
            this.endObject();
        }
    }

    private void write(ContentResult contentResult) throws IOException {
        if (contentResult.getName() != null) {
            this.beginObject();
            this.writeName(contentResult.getName());
        }
        if (contentResult.isEmpty()) {
            this.writeNull();
        } else if (contentResult.size() == 1) {
            ActionResult actionResult = (ActionResult)contentResult.get(0);
            if (actionResult.getActionId() != null) {
                this.beginObject();
                this.writeName(actionResult.getActionId());
                this.write(actionResult.getResultValue());
                this.endObject();
            } else {
                this.write(actionResult.getResultValue());
            }
        } else {
            this.beginObject();
            for (String actionId : contentResult.getActionIds()) {
                ActionResult actionResult = contentResult.getActionResult(actionId);
                this.writeName(actionResult.getActionId());
                this.write(actionResult.getResultValue());
            }
            this.endObject();
        }
        if (contentResult.getName() != null) {
            this.endObject();
        }
    }
}

