/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component;

import com.aspectran.core.component.Component;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.core.util.thread.AutoLock;

public abstract class AbstractComponent
implements Component {
    private static final Logger logger = LoggerFactory.getLogger(AbstractComponent.class);
    private final AutoLock lock = new AutoLock();
    private volatile boolean initialized;
    private volatile boolean destroying;
    private volatile boolean destroyed;

    protected abstract void doInitialize() throws Exception;

    protected abstract void doDestroy() throws Exception;

    @Override
    public void initialize() throws Exception {
        try (AutoLock ignored = this.lock.lock();){
            if (this.destroyed) {
                throw new IllegalStateException("Already destroyed " + this.getComponentName());
            }
            if (this.initialized) {
                throw new IllegalStateException("Already initialized " + this.getComponentName());
            }
            this.doInitialize();
            this.initialized = true;
            if (logger.isDebugEnabled()) {
                logger.debug("Initialized " + this.getComponentName());
            }
        }
    }

    @Override
    public void destroy() {
        try (AutoLock ignored = this.lock.lock();){
            if (!this.initialized) {
                throw new IllegalStateException("Not yet initialized " + this.getComponentName());
            }
            if (this.destroying || this.destroyed) {
                throw new IllegalStateException("Already destroyed " + this.getComponentName());
            }
            try {
                this.destroying = true;
                this.doDestroy();
                if (logger.isDebugEnabled()) {
                    logger.debug("Destroyed " + this.getComponentName());
                }
            }
            catch (Exception e) {
                logger.warn("Failed to destroy " + this.getComponentName(), e);
            }
            finally {
                this.destroying = false;
            }
            this.destroyed = true;
        }
    }

    @Override
    public boolean isAvailable() {
        return this.initialized && !this.destroying && !this.destroyed;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isDestroying() {
        return this.destroying;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public String getComponentName() {
        return this.getClass().getSimpleName() + "@" + Integer.toString(this.hashCode(), 16);
    }
}

