/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.aspect;

import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.aspect.AspectAdviceRulePostRegister;
import com.aspectran.core.component.aspect.AspectAdviceRuleRegistry;
import com.aspectran.core.component.aspect.RelevantAspectRuleHolder;
import com.aspectran.core.component.aspect.pointcut.Pointcut;
import com.aspectran.core.component.aspect.pointcut.PointcutPattern;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.type.JoinpointTargetType;
import com.aspectran.core.util.ConcurrentReferenceHashMap;
import com.aspectran.core.util.cache.Cache;
import com.aspectran.core.util.cache.ConcurrentReferenceCache;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class AspectRuleRegistry
extends AbstractComponent {
    private static final Logger logger = LoggerFactory.getLogger(AspectRuleRegistry.class);
    private static final RelevantAspectRuleHolder EMPTY_HOLDER = new RelevantAspectRuleHolder();
    private final Cache<PointcutPattern, RelevantAspectRuleHolder> softCache = new ConcurrentReferenceCache<PointcutPattern, RelevantAspectRuleHolder>(ConcurrentReferenceHashMap.ReferenceType.SOFT, this::createRelevantAspectRuleHolder);
    private final Cache<PointcutPattern, RelevantAspectRuleHolder> weakCache = new ConcurrentReferenceCache<PointcutPattern, RelevantAspectRuleHolder>(ConcurrentReferenceHashMap.ReferenceType.WEAK, this::createRelevantAspectRuleHolder);
    private final Map<String, AspectRule> aspectRuleMap = new LinkedHashMap<String, AspectRule>();

    public Collection<AspectRule> getAspectRules() {
        return this.aspectRuleMap.values();
    }

    public AspectRule getAspectRule(String aspectId) {
        return this.aspectRuleMap.get(aspectId);
    }

    public boolean contains(String aspectId) {
        return this.aspectRuleMap.containsKey(aspectId);
    }

    public void addAspectRule(AspectRule aspectRule) throws IllegalRuleException {
        if (aspectRule == null) {
            throw new IllegalArgumentException("aspectRule must not be null");
        }
        AspectRule old = this.aspectRuleMap.put(aspectRule.getId(), aspectRule);
        if (old != null) {
            throw new IllegalRuleException("Cannot add AspectRule due to duplicate Aspect ID: " + aspectRule.getId());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("add AspectRule " + aspectRule);
        }
    }

    @Override
    protected void doInitialize() {
    }

    @Override
    protected void doDestroy() {
        this.aspectRuleMap.clear();
    }

    public RelevantAspectRuleHolder getRelevantAspectRuleHolderFromSoftCache(PointcutPattern pointcutPattern) {
        return this.softCache.get(pointcutPattern);
    }

    public RelevantAspectRuleHolder getRelevantAspectRuleHolderFromWeakCache(PointcutPattern pointcutPattern) {
        return this.weakCache.get(pointcutPattern);
    }

    private RelevantAspectRuleHolder createRelevantAspectRuleHolder(PointcutPattern pointcutPattern) {
        AspectAdviceRulePostRegister postRegister = new AspectAdviceRulePostRegister();
        ArrayList<AspectRule> dynamicAspectRuleList = new ArrayList<AspectRule>();
        for (AspectRule aspectRule : this.getAspectRules()) {
            Pointcut pointcut;
            if (!aspectRule.isBeanRelevant() || (pointcut = aspectRule.getPointcut()) != null && !pointcut.matches(pointcutPattern)) continue;
            if (aspectRule.getJoinpointTargetType() == JoinpointTargetType.METHOD) {
                postRegister.register(aspectRule);
                continue;
            }
            dynamicAspectRuleList.add(aspectRule);
        }
        AspectAdviceRuleRegistry aarr = postRegister.getAspectAdviceRuleRegistry();
        if (!dynamicAspectRuleList.isEmpty() || aarr != null) {
            RelevantAspectRuleHolder holder = new RelevantAspectRuleHolder();
            holder.setAspectAdviceRuleRegistry(aarr);
            if (!dynamicAspectRuleList.isEmpty()) {
                holder.setDynamicAspectRuleList(dynamicAspectRuleList);
            }
            return holder;
        }
        return EMPTY_HOLDER;
    }
}

