/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean;

import com.aspectran.core.activity.process.action.AnnotatedAction;
import com.aspectran.core.activity.response.transform.CustomTransformResponse;
import com.aspectran.core.activity.response.transform.CustomTransformer;
import com.aspectran.core.component.bean.AnnotatedConfigRelater;
import com.aspectran.core.component.bean.BeanRuleAnalyzer;
import com.aspectran.core.component.bean.annotation.Action;
import com.aspectran.core.component.bean.annotation.After;
import com.aspectran.core.component.bean.annotation.Around;
import com.aspectran.core.component.bean.annotation.Aspect;
import com.aspectran.core.component.bean.annotation.AttrItem;
import com.aspectran.core.component.bean.annotation.Autowired;
import com.aspectran.core.component.bean.annotation.Bean;
import com.aspectran.core.component.bean.annotation.Before;
import com.aspectran.core.component.bean.annotation.Component;
import com.aspectran.core.component.bean.annotation.CronTrigger;
import com.aspectran.core.component.bean.annotation.Description;
import com.aspectran.core.component.bean.annotation.Destroy;
import com.aspectran.core.component.bean.annotation.Dispatch;
import com.aspectran.core.component.bean.annotation.ExceptionThrown;
import com.aspectran.core.component.bean.annotation.Format;
import com.aspectran.core.component.bean.annotation.Forward;
import com.aspectran.core.component.bean.annotation.Initialize;
import com.aspectran.core.component.bean.annotation.Job;
import com.aspectran.core.component.bean.annotation.Joinpoint;
import com.aspectran.core.component.bean.annotation.ParamItem;
import com.aspectran.core.component.bean.annotation.Profile;
import com.aspectran.core.component.bean.annotation.Qualifier;
import com.aspectran.core.component.bean.annotation.Redirect;
import com.aspectran.core.component.bean.annotation.Request;
import com.aspectran.core.component.bean.annotation.RequestToDelete;
import com.aspectran.core.component.bean.annotation.RequestToGet;
import com.aspectran.core.component.bean.annotation.RequestToPatch;
import com.aspectran.core.component.bean.annotation.RequestToPost;
import com.aspectran.core.component.bean.annotation.RequestToPut;
import com.aspectran.core.component.bean.annotation.Required;
import com.aspectran.core.component.bean.annotation.Schedule;
import com.aspectran.core.component.bean.annotation.Scope;
import com.aspectran.core.component.bean.annotation.Settings;
import com.aspectran.core.component.bean.annotation.SimpleTrigger;
import com.aspectran.core.component.bean.annotation.Transform;
import com.aspectran.core.component.bean.annotation.Value;
import com.aspectran.core.context.env.EnvironmentProfiles;
import com.aspectran.core.context.rule.AnnotatedActionRule;
import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.AutowireRule;
import com.aspectran.core.context.rule.AutowireTargetRule;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.DescriptionRule;
import com.aspectran.core.context.rule.DispatchRule;
import com.aspectran.core.context.rule.ExceptionThrownRule;
import com.aspectran.core.context.rule.ForwardRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.ItemRuleUtils;
import com.aspectran.core.context.rule.JoinpointRule;
import com.aspectran.core.context.rule.ParameterBindingRule;
import com.aspectran.core.context.rule.PointcutRule;
import com.aspectran.core.context.rule.RedirectRule;
import com.aspectran.core.context.rule.ResponseRule;
import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.core.context.rule.ScheduledJobRule;
import com.aspectran.core.context.rule.SettingsAdviceRule;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.type.AspectAdviceType;
import com.aspectran.core.context.rule.type.AutowireTargetType;
import com.aspectran.core.context.rule.type.FormatType;
import com.aspectran.core.context.rule.type.JoinpointTargetType;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.context.rule.type.ScopeType;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AnnotatedConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(AnnotatedConfigParser.class);
    private final EnvironmentProfiles environmentProfiles;
    private final Map<String, BeanRule> idBasedBeanRuleMap;
    private final Map<Class<?>, Set<BeanRule>> typeBasedBeanRuleMap;
    private final Map<Class<?>, BeanRule> configurableBeanRuleMap;
    private final AnnotatedConfigRelater configRelater;

    public AnnotatedConfigParser(ActivityRuleAssistant assistant, AnnotatedConfigRelater configRelater) {
        this.environmentProfiles = assistant.getEnvironmentProfiles();
        this.idBasedBeanRuleMap = assistant.getBeanRuleRegistry().getIdBasedBeanRuleMap();
        this.typeBasedBeanRuleMap = assistant.getBeanRuleRegistry().getTypeBasedBeanRuleMap();
        this.configurableBeanRuleMap = assistant.getBeanRuleRegistry().getConfigurableBeanRuleMap();
        this.configRelater = configRelater;
    }

    public void parse() throws IllegalRuleException {
        if (this.configurableBeanRuleMap.isEmpty() && this.idBasedBeanRuleMap.isEmpty() && this.typeBasedBeanRuleMap.isEmpty()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Now trying to parse annotated configurations");
        }
        if (!this.configurableBeanRuleMap.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Parsing bean rules for annotated configurations: " + this.configurableBeanRuleMap.size());
            }
            for (BeanRule beanRule : this.configurableBeanRuleMap.values()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("configurableBeanRule " + beanRule);
                }
                if (beanRule.isFactoryOffered()) continue;
                this.parseConfigurableBean(beanRule);
                this.parseConstructorAutowire(beanRule);
                this.parseFieldAutowire(beanRule);
                this.parseMethodAutowire(beanRule);
            }
        }
        if (!this.idBasedBeanRuleMap.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Parsing for ID-based bean rules: " + this.idBasedBeanRuleMap.size());
            }
            for (BeanRule beanRule : this.idBasedBeanRuleMap.values()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("idBasedBeanRule " + beanRule);
                }
                if (beanRule.isFactoryOffered()) continue;
                this.parseConstructorAutowire(beanRule);
                this.parseFieldAutowire(beanRule);
                this.parseMethodAutowire(beanRule);
            }
        }
        if (!this.typeBasedBeanRuleMap.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Parsing for type-based bean rules: " + this.typeBasedBeanRuleMap.size());
            }
            for (Set set : this.typeBasedBeanRuleMap.values()) {
                for (BeanRule beanRule : set) {
                    if (beanRule.isFactoryOffered()) continue;
                    if (logger.isTraceEnabled()) {
                        logger.trace("typeBasedBeanRule " + beanRule);
                    }
                    this.parseConstructorAutowire(beanRule);
                    this.parseFieldAutowire(beanRule);
                    this.parseMethodAutowire(beanRule);
                }
            }
        }
    }

    private void parseConfigurableBean(BeanRule beanRule) throws IllegalRuleException {
        Class<?> beanClass = beanRule.getBeanClass();
        Component componentAnno = beanClass.getAnnotation(Component.class);
        if (componentAnno != null) {
            Profile profileAnno;
            if (beanClass.isAnnotationPresent(Profile.class) && !this.environmentProfiles.acceptsProfiles((profileAnno = beanClass.getAnnotation(Profile.class)).value())) {
                return;
            }
            String[] nameArray = this.explodeNamespace(componentAnno.value());
            if (beanClass.isAnnotationPresent(Aspect.class)) {
                this.parseAspectRule(beanClass, nameArray);
            }
            if (beanClass.isAnnotationPresent(Bean.class)) {
                this.parseBeanRule(beanRule, nameArray);
            }
            if (beanClass.isAnnotationPresent(Schedule.class)) {
                this.parseScheduleRule(beanRule, nameArray);
            }
            for (Method method : beanClass.getMethods()) {
                Profile profileAnno2;
                if (method.isAnnotationPresent(Profile.class) && !this.environmentProfiles.acceptsProfiles((profileAnno2 = method.getAnnotation(Profile.class)).value())) continue;
                if (method.isAnnotationPresent(Bean.class)) {
                    this.parseFactoryBeanRule(beanClass, method, nameArray);
                    continue;
                }
                if (!method.isAnnotationPresent(Request.class) && !method.isAnnotationPresent(RequestToGet.class) && !method.isAnnotationPresent(RequestToPost.class) && !method.isAnnotationPresent(RequestToPut.class) && !method.isAnnotationPresent(RequestToPatch.class) && !method.isAnnotationPresent(RequestToDelete.class)) continue;
                this.parseTransletRule(beanClass, method, nameArray);
            }
        }
    }

    private void parseConstructorAutowire(BeanRule beanRule) throws IllegalRuleException {
        AutowireRule autowireRule;
        if (beanRule.isConstructorAutowireParsed()) {
            return;
        }
        beanRule.setConstructorAutowireParsed(true);
        ItemRuleMap ctorArgumentItemRuleMap = beanRule.getConstructorArgumentItemRuleMap();
        if (ctorArgumentItemRuleMap != null && !ctorArgumentItemRuleMap.isEmpty()) {
            return;
        }
        Class<?> beanClass = beanRule.getBeanClass();
        Constructor<?>[] constructors = beanClass.getDeclaredConstructors();
        Constructor<?> candidate = null;
        if (constructors.length == 1) {
            candidate = constructors[0];
        } else {
            for (Constructor<?> ctor : constructors) {
                if (!ctor.isAnnotationPresent(Autowired.class)) continue;
                candidate = ctor;
                break;
            }
        }
        if (candidate != null && (autowireRule = this.createAutowireRuleForConstructor(candidate)) != null) {
            beanRule.setConstructorAutowireRule(autowireRule);
            this.configRelater.relate(autowireRule);
        }
    }

    private void parseFieldAutowire(BeanRule beanRule) throws IllegalRuleException {
        if (beanRule.isFieldAutowireParsed()) {
            return;
        }
        beanRule.setFieldAutowireParsed(true);
        for (Class<?> beanClass = beanRule.getBeanClass(); beanClass != null && beanClass != Object.class; beanClass = beanClass.getSuperclass()) {
            for (Field field : beanClass.getDeclaredFields()) {
                AutowireRule autowireRule;
                if (field.isAnnotationPresent(Autowired.class)) {
                    autowireRule = this.createAutowireRuleForField(field);
                    beanRule.addAutowireRule(autowireRule);
                    this.configRelater.relate(autowireRule);
                    continue;
                }
                if (!field.isAnnotationPresent(Value.class) || (autowireRule = this.createAutowireRuleForFieldValue(field)) == null) continue;
                beanRule.addAutowireRule(autowireRule);
                this.configRelater.relate(autowireRule);
            }
        }
    }

    private void parseMethodAutowire(BeanRule beanRule) throws IllegalRuleException {
        if (beanRule.isMethodAutowireParsed()) {
            return;
        }
        beanRule.setMethodAutowireParsed(true);
        for (Class<?> beanClass = beanRule.getBeanClass(); beanClass != null && beanClass != Object.class; beanClass = beanClass.getSuperclass()) {
            for (Method method : beanClass.getDeclaredMethods()) {
                if (method.isAnnotationPresent(Autowired.class)) {
                    AutowireRule autowireRule = this.createAutowireRuleForMethod(method);
                    if (autowireRule == null) continue;
                    beanRule.addAutowireRule(autowireRule);
                    this.configRelater.relate(autowireRule);
                    continue;
                }
                if (method.isAnnotationPresent(Required.class)) {
                    BeanRuleAnalyzer.checkRequiredProperty(beanRule, method);
                    continue;
                }
                if (method.isAnnotationPresent(Initialize.class)) {
                    if (beanRule.isInitializableBean() || beanRule.getInitMethod() != null) continue;
                    beanRule.setInitMethod(method);
                    beanRule.setInitMethodParameterBindingRules(AnnotatedConfigParser.createParameterBindingRules(method));
                    continue;
                }
                if (!method.isAnnotationPresent(Destroy.class) || beanRule.isDisposableBean() || beanRule.getDestroyMethod() != null) continue;
                beanRule.setDestroyMethod(method);
            }
        }
    }

    private void parseAspectRule(Class<?> beanClass, String[] nameArray) throws IllegalRuleException {
        Object settingsAnno;
        String text;
        Aspect aspectAnno = beanClass.getAnnotation(Aspect.class);
        String aspectId = StringUtils.emptyToNull(aspectAnno.value());
        if (aspectId == null) {
            aspectId = StringUtils.emptyToNull(aspectAnno.id());
        }
        if (aspectId == null) {
            aspectId = beanClass.getName();
        }
        if (nameArray != null) {
            aspectId = this.applyNamespace(nameArray, aspectId);
        }
        int order = aspectAnno.order();
        boolean isolated = aspectAnno.isolated();
        AspectRule aspectRule = new AspectRule();
        aspectRule.setId(aspectId);
        aspectRule.setOrder(order);
        aspectRule.setIsolated(isolated);
        aspectRule.setAdviceBeanClass(beanClass);
        if (beanClass.isAnnotationPresent(Joinpoint.class)) {
            Joinpoint joinpointAnno = beanClass.getAnnotation(Joinpoint.class);
            JoinpointTargetType target = joinpointAnno.target();
            MethodType[] methods = joinpointAnno.methods();
            String[] headers = joinpointAnno.headers();
            String[] pointcut = joinpointAnno.pointcut();
            JoinpointRule joinpointRule = new JoinpointRule();
            joinpointRule.setJoinpointTargetType(target);
            if (methods.length > 0) {
                joinpointRule.setMethods(methods);
            }
            if (headers.length > 0) {
                joinpointRule.setHeaders(headers);
            }
            if (pointcut.length > 0) {
                joinpointRule.setPointcutRule(PointcutRule.newInstance(pointcut));
            }
            aspectRule.setJoinpointRule(joinpointRule);
        }
        if (beanClass.isAnnotationPresent(Settings.class) && !(text = StringUtils.toLineDelimitedString((settingsAnno = beanClass.getAnnotation(Settings.class)).value())).isEmpty()) {
            SettingsAdviceRule sar = new SettingsAdviceRule(aspectRule);
            SettingsAdviceRule.updateSettingsAdviceRule(sar, text);
            aspectRule.setSettingsAdviceRule(sar);
        }
        for (Method method : beanClass.getMethods()) {
            AspectAdviceRule aspectAdviceRule;
            if (method.isAnnotationPresent(Before.class)) {
                aspectAdviceRule = aspectRule.newAspectAdviceRule(AspectAdviceType.BEFORE);
                aspectAdviceRule.setExecutableAction(this.createAnnotatedMethodAction(null, beanClass, method));
                continue;
            }
            if (method.isAnnotationPresent(After.class)) {
                aspectAdviceRule = aspectRule.newAspectAdviceRule(AspectAdviceType.AFTER);
                aspectAdviceRule.setExecutableAction(this.createAnnotatedMethodAction(null, beanClass, method));
                continue;
            }
            if (method.isAnnotationPresent(Around.class)) {
                aspectAdviceRule = aspectRule.newAspectAdviceRule(AspectAdviceType.AROUND);
                aspectAdviceRule.setExecutableAction(this.createAnnotatedMethodAction(null, beanClass, method));
                continue;
            }
            if (!method.isAnnotationPresent(ExceptionThrown.class)) continue;
            ExceptionThrown exceptionThrownAnno = method.getAnnotation(ExceptionThrown.class);
            Class<? extends Throwable>[] types = exceptionThrownAnno.value();
            AnnotatedAction action = this.createAnnotatedMethodAction(null, beanClass, method);
            ExceptionThrownRule exceptionThrownRule = ExceptionThrownRule.newInstance(types, action);
            aspectRule.putExceptionThrownRule(exceptionThrownRule);
            if (method.isAnnotationPresent(Transform.class)) {
                Transform transformAnno = method.getAnnotation(Transform.class);
                TransformRule transformRule = this.parseTransformRule(transformAnno);
                exceptionThrownRule.applyResponseRule(transformRule);
                continue;
            }
            if (method.isAnnotationPresent(Dispatch.class)) {
                Dispatch dispatchAnno = method.getAnnotation(Dispatch.class);
                DispatchRule dispatchRule = this.parseDispatchRule(dispatchAnno);
                exceptionThrownRule.applyResponseRule(dispatchRule);
                continue;
            }
            if (method.isAnnotationPresent(Forward.class)) {
                throw new IllegalRuleException("Cannot apply the forward response rule to the exception thrown rule");
            }
            if (!method.isAnnotationPresent(Redirect.class)) continue;
            Redirect redirectAnno = method.getAnnotation(Redirect.class);
            RedirectRule redirectRule = this.parseRedirectRule(redirectAnno);
            exceptionThrownRule.applyResponseRule(redirectRule);
        }
        Description descriptionAnno = beanClass.getAnnotation(Description.class);
        DescriptionRule descriptionRule = this.parseDescriptionRule(descriptionAnno);
        if (descriptionRule != null) {
            aspectRule.setDescriptionRule(descriptionRule);
        }
        this.configRelater.relate(aspectRule);
    }

    private void parseBeanRule(BeanRule beanRule, String[] nameArray) throws IllegalRuleException {
        Description descriptionAnno;
        DescriptionRule descriptionRule;
        Class<?> beanClass = beanRule.getBeanClass();
        Bean beanAnno = beanClass.getAnnotation(Bean.class);
        String beanId = StringUtils.emptyToNull(beanAnno.value());
        if (beanId == null) {
            beanId = StringUtils.emptyToNull(beanAnno.id());
        }
        if (beanId != null && nameArray != null) {
            beanId = this.applyNamespace(nameArray, beanId);
        }
        String initMethodName = StringUtils.emptyToNull(beanAnno.initMethod());
        String destroyMethodName = StringUtils.emptyToNull(beanAnno.destroyMethod());
        boolean lazyInit = beanAnno.lazyInit();
        boolean lazyDestroy = beanAnno.lazyDestroy();
        boolean important = beanAnno.important();
        Scope scopeAnno = beanClass.getAnnotation(Scope.class);
        ScopeType scopeType = scopeAnno != null ? scopeAnno.value() : ScopeType.SINGLETON;
        beanRule.setId(beanId);
        beanRule.setScopeType(scopeType);
        beanRule.setInitMethodName(initMethodName);
        beanRule.setDestroyMethodName(destroyMethodName);
        if (lazyInit) {
            beanRule.setLazyInit(Boolean.TRUE);
        }
        if (lazyDestroy) {
            beanRule.setLazyDestroy(Boolean.TRUE);
        }
        if (important) {
            beanRule.setImportant(Boolean.TRUE);
        }
        if ((descriptionRule = this.parseDescriptionRule(descriptionAnno = beanClass.getAnnotation(Description.class))) != null) {
            beanRule.setDescriptionRule(descriptionRule);
        }
        Class<?> targetBeanClass = BeanRuleAnalyzer.determineBeanClass(beanRule);
        this.configRelater.relate(targetBeanClass, beanRule);
    }

    private void parseFactoryBeanRule(Class<?> beanClass, Method method, String[] nameArray) throws IllegalRuleException {
        Description descriptionAnno;
        DescriptionRule descriptionRule;
        Bean beanAnno = method.getAnnotation(Bean.class);
        String beanId = StringUtils.emptyToNull(beanAnno.value());
        if (beanId == null) {
            beanId = StringUtils.emptyToNull(beanAnno.id());
        }
        if (beanId == null) {
            beanId = method.getName();
        }
        if (nameArray != null) {
            beanId = this.applyNamespace(nameArray, beanId);
        }
        String initMethodName = StringUtils.emptyToNull(beanAnno.initMethod());
        String destroyMethodName = StringUtils.emptyToNull(beanAnno.destroyMethod());
        boolean lazyInit = beanAnno.lazyInit();
        boolean lazyDestroy = beanAnno.lazyDestroy();
        boolean important = beanAnno.important();
        Scope scopeAnno = beanClass.getAnnotation(Scope.class);
        ScopeType scopeType = scopeAnno != null ? scopeAnno.value() : ScopeType.SINGLETON;
        BeanRule beanRule = new BeanRule();
        beanRule.setId(beanId);
        beanRule.setScopeType(scopeType);
        beanRule.setFactoryBeanId("class:" + beanClass.getName());
        beanRule.setFactoryBeanClass(beanClass);
        beanRule.setFactoryMethodName(method.getName());
        beanRule.setFactoryMethod(method);
        beanRule.setFactoryMethodParameterBindingRules(AnnotatedConfigParser.createParameterBindingRules(method));
        beanRule.setFactoryOffered(true);
        beanRule.setInitMethodName(initMethodName);
        beanRule.setDestroyMethodName(destroyMethodName);
        if (lazyInit) {
            beanRule.setLazyInit(Boolean.TRUE);
        }
        if (lazyDestroy) {
            beanRule.setLazyDestroy(Boolean.TRUE);
        }
        if (important) {
            beanRule.setImportant(Boolean.TRUE);
        }
        if ((descriptionRule = this.parseDescriptionRule(descriptionAnno = beanClass.getAnnotation(Description.class))) != null) {
            beanRule.setDescriptionRule(descriptionRule);
        }
        Class<?> targetBeanClass = BeanRuleAnalyzer.determineBeanClass(beanRule);
        this.configRelater.relate(targetBeanClass, beanRule);
    }

    private void parseScheduleRule(BeanRule beanRule, String[] nameArray) throws IllegalRuleException {
        Job[] jobs;
        CronTrigger cronTriggerAnno;
        String expression;
        Class<?> beanClass = beanRule.getBeanClass();
        Schedule scheduleAnno = beanClass.getAnnotation(Schedule.class);
        String scheduleId = StringUtils.emptyToNull(scheduleAnno.id());
        if (scheduleId != null && nameArray != null) {
            scheduleId = this.applyNamespace(nameArray, scheduleId);
        }
        ScheduleRule scheduleRule = ScheduleRule.newInstance(scheduleId);
        String schedulerBeanId = StringUtils.emptyToNull(scheduleAnno.scheduler());
        if (schedulerBeanId != null) {
            scheduleRule.setSchedulerBeanId(schedulerBeanId);
        }
        if ((expression = StringUtils.emptyToNull((cronTriggerAnno = scheduleAnno.cronTrigger()).expression())) != null) {
            ScheduleRule.updateTriggerExpression(scheduleRule, cronTriggerAnno);
        } else {
            SimpleTrigger simpleTriggerAnno = scheduleAnno.simpleTrigger();
            ScheduleRule.updateTriggerExpression(scheduleRule, simpleTriggerAnno);
        }
        for (Job job : jobs = scheduleAnno.jobs()) {
            String transletName = StringUtils.emptyToNull(job.value());
            if (transletName == null) {
                transletName = StringUtils.emptyToNull(job.translet());
            }
            ScheduledJobRule jobRule = new ScheduledJobRule(scheduleRule);
            jobRule.setTransletName(transletName);
            if (job.disabled()) {
                jobRule.setDisabled(true);
            }
            scheduleRule.addScheduledJobRule(jobRule);
        }
        Description descriptionAnno = beanClass.getAnnotation(Description.class);
        DescriptionRule descriptionRule = this.parseDescriptionRule(descriptionAnno);
        if (descriptionRule != null) {
            scheduleRule.setDescriptionRule(descriptionRule);
        }
        this.configRelater.relate(scheduleRule);
    }

    private void parseTransletRule(Class<?> beanClass, Method method, String[] nameArray) throws IllegalRuleException {
        Action actionAnno;
        AttrItem[] attrItemAnnos;
        Request requestAnno = method.getAnnotation(Request.class);
        RequestToGet requestToGetAnno = method.getAnnotation(RequestToGet.class);
        RequestToPost requestToPostAnno = method.getAnnotation(RequestToPost.class);
        RequestToPut requestToPutAnno = method.getAnnotation(RequestToPut.class);
        RequestToPatch requestToPatchAnno = method.getAnnotation(RequestToPatch.class);
        RequestToDelete requestToDeleteAnno = method.getAnnotation(RequestToDelete.class);
        String transletName = null;
        MethodType[] allowedMethods = null;
        if (requestAnno != null) {
            transletName = StringUtils.emptyToNull(requestAnno.value());
            if (transletName == null) {
                transletName = StringUtils.emptyToNull(requestAnno.translet());
            }
            allowedMethods = requestAnno.method();
        } else if (requestToGetAnno != null) {
            transletName = StringUtils.emptyToNull(requestToGetAnno.value());
            allowedMethods = new MethodType[]{MethodType.GET};
        } else if (requestToPostAnno != null) {
            transletName = StringUtils.emptyToNull(requestToPostAnno.value());
            allowedMethods = new MethodType[]{MethodType.POST};
        } else if (requestToPutAnno != null) {
            transletName = StringUtils.emptyToNull(requestToPutAnno.value());
            allowedMethods = new MethodType[]{MethodType.PUT};
        } else if (requestToPatchAnno != null) {
            transletName = StringUtils.emptyToNull(requestToPatchAnno.value());
            allowedMethods = new MethodType[]{MethodType.PATCH};
        } else if (requestToDeleteAnno != null) {
            transletName = StringUtils.emptyToNull(requestToDeleteAnno.value());
            allowedMethods = new MethodType[]{MethodType.DELETE};
        }
        if (nameArray != null) {
            transletName = this.applyNamespaceForTranslet(nameArray, transletName);
        }
        TransletRule transletRule = TransletRule.newInstance(transletName, allowedMethods);
        ParamItem[] paramItemAnnos = (ParamItem[])method.getAnnotationsByType(ParamItem.class);
        if (paramItemAnnos.length > 0) {
            ItemRuleMap itemRuleMap = new ItemRuleMap();
            for (ParamItem paramItemAnno : paramItemAnnos) {
                String profile = StringUtils.emptyToNull(paramItemAnno.profile());
                if (profile != null && !this.environmentProfiles.acceptsProfiles(profile)) continue;
                itemRuleMap.putItemRule(ItemRuleUtils.toItemRule(paramItemAnno));
            }
            transletRule.touchRequestRule(false).setParameterItemRuleMap(itemRuleMap);
        }
        if ((attrItemAnnos = (AttrItem[])method.getAnnotationsByType(AttrItem.class)).length > 0) {
            ItemRuleMap itemRuleMap = new ItemRuleMap();
            for (AttrItem attrItemAnno : attrItemAnnos) {
                String profile = StringUtils.emptyToNull(attrItemAnno.profile());
                if (profile != null && !this.environmentProfiles.acceptsProfiles(profile)) continue;
                itemRuleMap.putItemRule(ItemRuleUtils.toItemRule(attrItemAnno));
            }
            transletRule.touchRequestRule(false).setAttributeItemRuleMap(itemRuleMap);
        }
        String actionId = (actionAnno = method.getAnnotation(Action.class)) != null ? StringUtils.emptyToNull(actionAnno.value()) : null;
        AnnotatedAction annotatedAction = this.createAnnotatedMethodAction(actionId, beanClass, method);
        transletRule.applyActionRule(annotatedAction);
        Class<?> returnType = method.getReturnType();
        if (CustomTransformer.class.isAssignableFrom(returnType)) {
            transletRule.setResponseRule(ResponseRule.newInstance(new CustomTransformResponse()));
        } else if (method.isAnnotationPresent(Transform.class)) {
            Transform transformAnno = method.getAnnotation(Transform.class);
            TransformRule transformRule = this.parseTransformRule(transformAnno);
            transletRule.setResponseRule(ResponseRule.newInstance(transformRule));
        } else if (method.isAnnotationPresent(Dispatch.class)) {
            Dispatch dispatchAnno = method.getAnnotation(Dispatch.class);
            DispatchRule dispatchRule = this.parseDispatchRule(dispatchAnno);
            transletRule.setResponseRule(ResponseRule.newInstance(dispatchRule));
        } else if (method.isAnnotationPresent(Forward.class)) {
            Forward forwardAnno = method.getAnnotation(Forward.class);
            ForwardRule forwardRule = this.parseForwardRule(forwardAnno);
            transletRule.setResponseRule(ResponseRule.newInstance(forwardRule));
        } else if (method.isAnnotationPresent(Redirect.class)) {
            Redirect redirectAnno = method.getAnnotation(Redirect.class);
            RedirectRule redirectRule = this.parseRedirectRule(redirectAnno);
            transletRule.setResponseRule(ResponseRule.newInstance(redirectRule));
        }
        Description descriptionAnno = beanClass.getAnnotation(Description.class);
        DescriptionRule descriptionRule = this.parseDescriptionRule(descriptionAnno);
        if (descriptionRule != null) {
            transletRule.setDescriptionRule(descriptionRule);
        }
        this.configRelater.relate(transletRule);
    }

    private TransformRule parseTransformRule(Transform transformAnno) {
        FormatType formatType = transformAnno.value();
        if (formatType == FormatType.NONE) {
            formatType = transformAnno.format();
        }
        String contentType = StringUtils.emptyToNull(transformAnno.contentType());
        String templateId = StringUtils.emptyToNull(transformAnno.template());
        String encoding = StringUtils.emptyToNull(transformAnno.encoding());
        boolean pretty = transformAnno.pretty();
        TransformRule transformRule = TransformRule.newInstance(formatType, contentType, encoding, pretty);
        transformRule.setTemplateId(templateId);
        return transformRule;
    }

    private DispatchRule parseDispatchRule(Dispatch dispatchAnno) throws IllegalRuleException {
        String name = StringUtils.emptyToNull(dispatchAnno.value());
        if (name == null) {
            name = StringUtils.emptyToNull(dispatchAnno.name());
        }
        String dispatcher = StringUtils.emptyToNull(dispatchAnno.dispatcher());
        String contentType = StringUtils.emptyToNull(dispatchAnno.contentType());
        String encoding = StringUtils.emptyToNull(dispatchAnno.encoding());
        return DispatchRule.newInstance(name, dispatcher, contentType, encoding);
    }

    private ForwardRule parseForwardRule(Forward forwardAnno) throws IllegalRuleException {
        String translet = StringUtils.emptyToNull(forwardAnno.value());
        if (translet == null) {
            translet = StringUtils.emptyToNull(forwardAnno.translet());
        }
        ForwardRule forwardRule = ForwardRule.newInstance(translet);
        AttrItem[] attrItemAnnos = forwardAnno.attributes();
        if (attrItemAnnos.length > 0) {
            ItemRuleMap itemRuleMap = new ItemRuleMap();
            for (AttrItem attrItemAnno : attrItemAnnos) {
                String profile = StringUtils.emptyToNull(attrItemAnno.profile());
                if (profile != null && !this.environmentProfiles.acceptsProfiles(profile)) continue;
                itemRuleMap.putItemRule(ItemRuleUtils.toItemRule(attrItemAnno));
            }
            forwardRule.setAttributeItemRuleMap(itemRuleMap);
        }
        return forwardRule;
    }

    private RedirectRule parseRedirectRule(Redirect redirectAnno) throws IllegalRuleException {
        String path = StringUtils.emptyToNull(redirectAnno.value());
        if (path == null) {
            path = StringUtils.emptyToNull(redirectAnno.path());
        }
        RedirectRule redirectRule = RedirectRule.newInstance(path);
        ParamItem[] paramItemAnnos = redirectAnno.parameters();
        if (paramItemAnnos.length > 0) {
            ItemRuleMap itemRuleMap = new ItemRuleMap();
            for (ParamItem paramItemAnno : paramItemAnnos) {
                String profile = StringUtils.emptyToNull(paramItemAnno.profile());
                if (profile != null && !this.environmentProfiles.acceptsProfiles(profile)) continue;
                itemRuleMap.putItemRule(ItemRuleUtils.toItemRule(paramItemAnno));
            }
            redirectRule.setParameterItemRuleMap(itemRuleMap);
        }
        return redirectRule;
    }

    private DescriptionRule parseDescriptionRule(Description descriptionAnno) {
        String description;
        if (descriptionAnno != null && (description = StringUtils.emptyToNull(descriptionAnno.value())) != null) {
            DescriptionRule descriptionRule = new DescriptionRule();
            descriptionRule.setContent(description);
            return descriptionRule;
        }
        return null;
    }

    private AutowireRule createAutowireRuleForConstructor(Constructor<?> constructor) throws IllegalRuleException {
        Parameter[] params = constructor.getParameters();
        if (params.length == 0) {
            return null;
        }
        AutowireTargetRule[] autowireTargetRules = AutowireTargetRule.newArrayInstance(params.length);
        for (int i = 0; i < params.length; ++i) {
            String qualifier;
            if (params[i].getType().isArray()) {
                autowireTargetRules[i].setType(params[i].getType().getComponentType());
            } else {
                autowireTargetRules[i].setType(params[i].getType());
            }
            Value ValueAnno = params[i].getAnnotation(Value.class);
            if (ValueAnno != null) {
                String expression = StringUtils.emptyToNull(ValueAnno.value());
                if (expression == null) continue;
                autowireTargetRules[i].setExpression(expression);
                continue;
            }
            Qualifier qualifierAnno = params[i].getAnnotation(Qualifier.class);
            if (qualifierAnno == null || (qualifier = StringUtils.emptyToNull(qualifierAnno.value())) == null) continue;
            autowireTargetRules[i].setQualifier(qualifier);
        }
        Autowired autowiredAnno = constructor.getAnnotation(Autowired.class);
        boolean required = autowiredAnno == null || autowiredAnno.required();
        AutowireRule autowireRule = new AutowireRule();
        autowireRule.setTargetType(AutowireTargetType.CONSTRUCTOR);
        autowireRule.setTarget(constructor);
        autowireRule.setAutowireTargetRules(autowireTargetRules);
        autowireRule.setRequired(required);
        return autowireRule;
    }

    private AutowireRule createAutowireRuleForField(Field field) throws IllegalRuleException {
        AutowireTargetRule autowireTargetRule = AutowireTargetRule.newInstance();
        autowireTargetRule.setType(field.getType());
        Value ValueAnno = field.getAnnotation(Value.class);
        if (ValueAnno != null) {
            String expression = StringUtils.emptyToNull(ValueAnno.value());
            if (expression != null) {
                autowireTargetRule.setExpression(expression);
            }
        } else {
            String qualifier;
            Qualifier qualifierAnno = field.getAnnotation(Qualifier.class);
            if (qualifierAnno != null && (qualifier = StringUtils.emptyToNull(qualifierAnno.value())) != null) {
                autowireTargetRule.setQualifier(qualifier);
            }
        }
        Autowired autowiredAnno = field.getAnnotation(Autowired.class);
        boolean required = autowiredAnno == null || autowiredAnno.required();
        AutowireRule autowireRule = new AutowireRule();
        autowireRule.setTargetType(AutowireTargetType.FIELD);
        autowireRule.setTarget(field);
        autowireRule.setAutowireTargetRules(autowireTargetRule);
        autowireRule.setRequired(required);
        return autowireRule;
    }

    private AutowireRule createAutowireRuleForFieldValue(Field field) throws IllegalRuleException {
        String expression;
        Value valueAnno = field.getAnnotation(Value.class);
        if (valueAnno != null && (expression = StringUtils.emptyToNull(valueAnno.value())) != null) {
            AutowireTargetRule autowireTargetRule = AutowireTargetRule.newInstance();
            autowireTargetRule.setExpression(expression);
            Autowired autowiredAnno = field.getAnnotation(Autowired.class);
            boolean required = autowiredAnno != null && autowiredAnno.required();
            AutowireRule autowireRule = new AutowireRule();
            autowireRule.setTargetType(AutowireTargetType.FIELD_VALUE);
            autowireRule.setTarget(field);
            autowireRule.setAutowireTargetRules(autowireTargetRule);
            autowireRule.setRequired(required);
            return autowireRule;
        }
        return null;
    }

    private AutowireRule createAutowireRuleForMethod(Method method) throws IllegalRuleException {
        Parameter[] params = method.getParameters();
        if (params.length == 0) {
            return null;
        }
        String upperQualifier = null;
        Qualifier typicalQualifierAnno = method.getAnnotation(Qualifier.class);
        if (typicalQualifierAnno != null) {
            upperQualifier = StringUtils.emptyToNull(typicalQualifierAnno.value());
        }
        AutowireTargetRule[] autowireTargetRules = AutowireTargetRule.newArrayInstance(params.length);
        for (int i = 0; i < params.length; ++i) {
            if (params[i].getType().isArray()) {
                autowireTargetRules[i].setType(params[i].getType().getComponentType());
            } else {
                autowireTargetRules[i].setType(params[i].getType());
            }
            Value ValueAnno = params[i].getAnnotation(Value.class);
            if (ValueAnno != null) {
                String expression = StringUtils.emptyToNull(ValueAnno.value());
                if (expression == null) continue;
                autowireTargetRules[i].setExpression(expression);
                continue;
            }
            Qualifier qualifierAnno = params[i].getAnnotation(Qualifier.class);
            String qualifier = qualifierAnno != null ? StringUtils.emptyToNull(qualifierAnno.value()) : upperQualifier;
            if (qualifier == null) continue;
            autowireTargetRules[i].setQualifier(qualifier);
        }
        Autowired autowiredAnno = method.getAnnotation(Autowired.class);
        boolean required = autowiredAnno == null || autowiredAnno.required();
        AutowireRule autowireRule = new AutowireRule();
        autowireRule.setTargetType(AutowireTargetType.METHOD);
        autowireRule.setTarget(method);
        autowireRule.setAutowireTargetRules(autowireTargetRules);
        autowireRule.setRequired(required);
        return autowireRule;
    }

    private AnnotatedAction createAnnotatedMethodAction(String actionId, Class<?> beanClass, Method method) {
        AnnotatedActionRule annotatedActionRule = new AnnotatedActionRule();
        annotatedActionRule.setActionId(actionId);
        annotatedActionRule.setBeanClass(beanClass);
        annotatedActionRule.setMethod(method);
        annotatedActionRule.setParameterBindingRules(AnnotatedConfigParser.createParameterBindingRules(method));
        return new AnnotatedAction(annotatedActionRule);
    }

    static ParameterBindingRule[] createParameterBindingRules(Method method) {
        Parameter[] params = method.getParameters();
        if (params.length == 0) {
            return null;
        }
        ParameterBindingRule[] bindingRules = new ParameterBindingRule[params.length];
        int cnt = 0;
        for (Parameter param : params) {
            Qualifier qualifierAnno = param.getAnnotation(Qualifier.class);
            String qualifier = null;
            if (qualifierAnno != null) {
                qualifier = StringUtils.emptyToNull(qualifierAnno.value());
            }
            if (qualifier == null) {
                qualifier = param.getName();
            }
            Format formatAnno = param.getAnnotation(Format.class);
            String format = null;
            if (formatAnno != null) {
                format = StringUtils.emptyToNull(formatAnno.value());
            }
            boolean required = param.isAnnotationPresent(Required.class);
            ParameterBindingRule bindingRule = new ParameterBindingRule();
            bindingRule.setType(param.getType());
            bindingRule.setName(qualifier);
            bindingRule.setFormat(format);
            bindingRule.setRequired(required);
            bindingRules[cnt++] = bindingRule;
        }
        return bindingRules;
    }

    private String[] explodeNamespace(String namespace) {
        if (StringUtils.isEmpty(namespace)) {
            return null;
        }
        int cnt = StringUtils.search((CharSequence)(namespace = namespace.replace('/', '.')), '.');
        if (cnt == 0) {
            String[] arr = new String[2];
            arr[1] = namespace;
            return arr;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(namespace, ".");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        list.add(null);
        Collections.reverse(list);
        return list.toArray(new String[0]);
    }

    private String applyNamespace(String[] nameArray, String name) {
        if (nameArray == null) {
            return name;
        }
        nameArray[0] = StringUtils.startsWith(name, '.') ? name.substring(1) : name;
        StringBuilder sb = new StringBuilder();
        for (int i = nameArray.length - 1; i >= 0; --i) {
            sb.append(nameArray[i]);
            if (i <= 0) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    private String applyNamespaceForTranslet(String[] nameArray, String name) {
        if (nameArray == null) {
            return name;
        }
        nameArray[0] = StringUtils.startsWith(name, '/') ? name.substring(1) : name;
        StringBuilder sb = new StringBuilder();
        for (int i = nameArray.length - 1; i >= 0; --i) {
            if (nameArray[i] == null) continue;
            sb.append('/');
            sb.append(nameArray[i]);
        }
        return sb.toString();
    }
}

