/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean.proxy;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.InstantActivity;
import com.aspectran.core.activity.InstantActivityException;
import com.aspectran.core.component.aspect.AspectAdviceRuleRegistry;
import com.aspectran.core.component.bean.proxy.AbstractDynamicProxyBean;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.rule.BeanRule;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class CglibDynamicProxyBean
extends AbstractDynamicProxyBean
implements MethodInterceptor {
    private final ActivityContext context;
    private final BeanRule beanRule;

    private CglibDynamicProxyBean(ActivityContext context, BeanRule beanRule) {
        super(context.getAspectRuleRegistry());
        this.context = context;
        this.beanRule = beanRule;
    }

    public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        if (this.isAvoidAdvice(method)) {
            return methodProxy.invokeSuper(proxy, args);
        }
        if (this.context.hasCurrentActivity()) {
            Activity activity = this.context.getCurrentActivity();
            return this.intercept(proxy, method, args, methodProxy, activity);
        }
        try {
            InstantActivity activity = new InstantActivity(this.context);
            return activity.perform(() -> this.intercept(proxy, method, args, methodProxy, activity));
        }
        catch (Exception e) {
            throw new InstantActivityException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy, Activity activity) throws Throwable {
        Object object;
        String methodName;
        String className;
        String beanId = this.beanRule.getId();
        AspectAdviceRuleRegistry aarr = this.getAspectAdviceRuleRegistry(activity, beanId, className = this.beanRule.getClassName(), methodName = method.getName());
        if (aarr == null) {
            return methodProxy.invokeSuper(proxy, args);
        }
        try {
            this.beforeAdvice(aarr.getBeforeAdviceRuleList(), this.beanRule, activity);
            Object result = methodProxy.invokeSuper(proxy, args);
            this.afterAdvice(aarr.getAfterAdviceRuleList(), this.beanRule, activity);
            object = result;
        }
        catch (Throwable throwable) {
            try {
                this.finallyAdvice(aarr.getFinallyAdviceRuleList(), this.beanRule, activity);
                throw throwable;
            }
            catch (Exception e) {
                if (this.exception(aarr.getExceptionRuleList(), e, activity)) {
                    return null;
                }
                throw e;
            }
        }
        this.finallyAdvice(aarr.getFinallyAdviceRuleList(), this.beanRule, activity);
        return object;
    }

    public static Object newInstance(ActivityContext context, BeanRule beanRule, Object[] args, Class<?>[] argTypes) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(context.getApplicationAdapter().getClassLoader());
        enhancer.setSuperclass(beanRule.getBeanClass());
        enhancer.setCallback((Callback)new CglibDynamicProxyBean(context, beanRule));
        return enhancer.create((Class[])argTypes, args);
    }
}

