/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.aware.ApplicationAdapterAware;
import com.aspectran.core.component.session.AbstractSessionHandler;
import com.aspectran.core.component.session.DefaultSessionCache;
import com.aspectran.core.component.session.FileSessionStoreFactory;
import com.aspectran.core.component.session.HouseKeeper;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionIdGenerator;
import com.aspectran.core.component.session.SessionManager;
import com.aspectran.core.component.session.SessionStore;
import com.aspectran.core.component.session.SessionStoreFactory;
import com.aspectran.core.context.config.SessionFileStoreConfig;
import com.aspectran.core.context.config.SessionManagerConfig;
import com.aspectran.core.util.StringUtils;
import java.io.IOException;

public class DefaultSessionManager
extends AbstractSessionHandler
implements SessionManager,
ApplicationAdapterAware,
DisposableBean {
    private ApplicationAdapter applicationAdapter;
    private SessionManagerConfig sessionManagerConfig;
    private SessionStoreFactory sessionStoreFactory;

    public DefaultSessionManager() {
    }

    public DefaultSessionManager(String workerName) {
        this.setWorkerName(workerName);
    }

    public ApplicationAdapter getApplicationAdapter() {
        return this.applicationAdapter;
    }

    @Override
    public void setApplicationAdapter(ApplicationAdapter applicationAdapter) {
        this.applicationAdapter = applicationAdapter;
    }

    public void setSessionManagerConfig(SessionManagerConfig sessionManagerConfig) {
        this.sessionManagerConfig = sessionManagerConfig;
    }

    public void setSessionManagerConfigWithApon(String apon) {
        SessionManagerConfig sessionManagerConfig = new SessionManagerConfig();
        try {
            sessionManagerConfig.readFrom(apon);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setSessionManagerConfig(sessionManagerConfig);
    }

    public void setSessionStoreFactory(SessionStoreFactory sessionStoreFactory) {
        this.sessionStoreFactory = sessionStoreFactory;
    }

    @Override
    public SessionHandler getSessionHandler() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("DefaultSessionManager is not yet initialized");
        }
        return this;
    }

    @Override
    protected void doInitialize() throws Exception {
        boolean clusterEnabled = false;
        if (this.sessionManagerConfig != null) {
            int secs;
            if (this.sessionManagerConfig.isClusterEnabled()) {
                clusterEnabled = true;
            }
            if (this.sessionManagerConfig.hasWorkerName()) {
                this.setWorkerName(this.sessionManagerConfig.getWorkerName());
            }
            if (this.sessionManagerConfig.hasMaxIdleSeconds()) {
                secs = this.sessionManagerConfig.getMaxIdleSeconds();
                this.setDefaultMaxIdleSecs(secs);
            }
            if (this.sessionManagerConfig.hasScavengingIntervalSeconds()) {
                secs = this.sessionManagerConfig.getScavengingIntervalSeconds();
                if (secs > 0) {
                    HouseKeeper houseKeeper = new HouseKeeper(this);
                    houseKeeper.setScavengingInterval(secs);
                    this.setHouseKeeper(houseKeeper);
                }
            } else {
                this.setHouseKeeper(new HouseKeeper(this));
            }
        }
        if (this.getSessionIdGenerator() == null) {
            SessionIdGenerator sessionIdGenerator = new SessionIdGenerator(this.getWorkerName());
            this.setSessionIdGenerator(sessionIdGenerator);
        }
        if (this.getSessionCache() == null) {
            SessionFileStoreConfig fileStoreConfig;
            SessionStore sessionStore = null;
            if (this.sessionStoreFactory != null) {
                sessionStore = this.sessionStoreFactory.getSessionStore();
            } else if (this.sessionManagerConfig != null && (fileStoreConfig = this.sessionManagerConfig.getFileStoreConfig()) != null) {
                String[] nonPersistentAttributes;
                boolean deleteUnrestorableFiles;
                FileSessionStoreFactory fileSessionStoreFactory = new FileSessionStoreFactory();
                fileSessionStoreFactory.setApplicationAdapter(this.applicationAdapter);
                String storeDir = fileStoreConfig.getStoreDir();
                if (StringUtils.hasText(storeDir)) {
                    fileSessionStoreFactory.setStoreDir(storeDir);
                }
                if (deleteUnrestorableFiles = fileStoreConfig.isDeleteUnrestorableFiles()) {
                    fileSessionStoreFactory.setDeleteUnrestorableFiles(true);
                }
                if ((nonPersistentAttributes = fileStoreConfig.getNonPersistentAttributes()) != null) {
                    fileSessionStoreFactory.setNonPersistentAttributes(nonPersistentAttributes);
                }
                this.sessionStoreFactory = fileSessionStoreFactory;
                sessionStore = fileSessionStoreFactory.getSessionStore();
            }
            DefaultSessionCache sessionCache = new DefaultSessionCache(this, sessionStore, clusterEnabled);
            if (this.sessionManagerConfig != null) {
                if (this.sessionManagerConfig.hasMaxSessions()) {
                    int maxSessions = this.sessionManagerConfig.getMaxSessions();
                    sessionCache.setMaxSessions(maxSessions);
                }
                if (this.sessionManagerConfig.hasEvictionIdleSeconds()) {
                    int secs = this.sessionManagerConfig.getEvictionIdleSeconds();
                    sessionCache.setEvictionIdleSecs(secs);
                }
                if (this.sessionManagerConfig.hasSaveOnCreate()) {
                    boolean saveOnCreate = this.sessionManagerConfig.getSaveOnCreate();
                    sessionCache.setSaveOnCreate(saveOnCreate);
                }
                if (this.sessionManagerConfig.hasSaveOnInactiveEviction()) {
                    boolean saveOnInactiveEviction = this.sessionManagerConfig.getSaveOnInactiveEviction();
                    sessionCache.setSaveOnInactiveEviction(saveOnInactiveEviction);
                }
                if (this.sessionManagerConfig.hasRemoveUnloadableSessions()) {
                    boolean removeUnloadableSessions = this.sessionManagerConfig.getRemoveUnloadableSessions();
                    sessionCache.setRemoveUnloadableSessions(removeUnloadableSessions);
                }
            }
            sessionCache.initialize();
            this.setSessionCache(sessionCache);
        }
        super.doInitialize();
    }
}

