/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.lifecycle.AbstractLifeCycle;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.core.util.thread.AutoLock;
import com.aspectran.core.util.thread.Scheduler;
import java.util.concurrent.TimeUnit;

public class HouseKeeper
extends AbstractLifeCycle {
    private static final Logger logger = LoggerFactory.getLogger(HouseKeeper.class);
    public static final long DEFAULT_SCAVENGING_INTERVAL_MS = 600000L;
    private final AutoLock lock = new AutoLock();
    private final SessionHandler sessionHandler;
    private final Scheduler scheduler;
    private Scheduler.Task task;
    private Runner runner;
    private long scavengingInterval = 600000L;

    public HouseKeeper(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
        this.scheduler = sessionHandler.getScheduler();
    }

    public int getScavengingInterval() {
        return (int)(this.scavengingInterval / 1000L);
    }

    public void setScavengingInterval(int intervalInSecs) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.isStarted() || this.isStarting()) {
                if (intervalInSecs <= 0) {
                    this.scavengingInterval = 0L;
                    logger.info("Scavenging disabled");
                    this.stopScavenging();
                } else {
                    if (intervalInSecs < 10) {
                        logger.warn("Short interval of " + intervalInSecs + " secs for session scavenging");
                    }
                    this.scavengingInterval = (long)intervalInSecs * 1000L;
                    if (this.isStarting() || this.isStarted()) {
                        this.startScavenging();
                    }
                }
            } else {
                this.scavengingInterval = (long)intervalInSecs * 1000L;
            }
        }
    }

    protected void startScavenging() {
        try (AutoLock ignored = this.lock.lock();){
            if (this.task != null) {
                this.task.cancel();
            }
            if (this.runner == null) {
                this.runner = new Runner();
            }
            logger.info(this.sessionHandler.getComponentName() + " Scavenging every " + this.scavengingInterval + " ms");
            this.task = this.scheduler.schedule(this.runner, this.scavengingInterval, TimeUnit.MILLISECONDS);
        }
    }

    protected void stopScavenging() {
        try (AutoLock ignored = this.lock.lock();){
            if (this.task != null) {
                this.task.cancel();
                logger.info(this.sessionHandler.getComponentName() + " Stopped scavenging");
            }
            this.task = null;
            this.runner = null;
        }
    }

    private void scavenge() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        try {
            this.sessionHandler.scavenge();
        }
        catch (Exception e) {
            logger.warn(e);
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.setScavengingInterval(this.getScavengingInterval());
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this.stopScavenging();
        super.doStop();
    }

    @Override
    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(super.toString());
        tsb.append("scavengingInterval", this.scavengingInterval);
        return tsb.toString();
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HouseKeeper.this.scavenge();
            }
            finally {
                try (AutoLock ignored = HouseKeeper.this.lock.lock();){
                    if (HouseKeeper.this.scheduler != null && HouseKeeper.this.scheduler.isRunning()) {
                        HouseKeeper.this.task = HouseKeeper.this.scheduler.schedule(this, HouseKeeper.this.scavengingInterval, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }
    }
}

