/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.template;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityData;
import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.template.TemplateNotFoundException;
import com.aspectran.core.component.template.TemplateRenderer;
import com.aspectran.core.component.template.TemplateRenderingException;
import com.aspectran.core.component.template.TemplateRuleRegistry;
import com.aspectran.core.component.template.engine.TemplateEngine;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.expr.TokenEvaluation;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.rule.TemplateRule;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;

public class DefaultTemplateRenderer
extends AbstractComponent
implements TemplateRenderer {
    private final ActivityContext context;
    private final TemplateRuleRegistry templateRuleRegistry;

    public DefaultTemplateRenderer(ActivityContext context, TemplateRuleRegistry templateRuleRegistry) {
        this.context = context;
        this.templateRuleRegistry = templateRuleRegistry;
    }

    @Override
    public String render(String templateId) {
        StringWriter writer = new StringWriter();
        this.render(templateId, null, null, (Writer)writer);
        return writer.toString();
    }

    @Override
    public String render(String templateId, Map<String, Object> model) {
        StringWriter writer = new StringWriter();
        this.render(templateId, null, model, (Writer)writer);
        return writer.toString();
    }

    @Override
    public String render(TemplateRule templateRule, Map<String, Object> model) {
        StringWriter writer = new StringWriter();
        this.render(templateRule, null, model, (Writer)writer);
        return writer.toString();
    }

    @Override
    public void render(String templateId, Activity activity) {
        this.render(templateId, activity, null, null);
    }

    @Override
    public void render(TemplateRule templateRule, Activity activity) {
        this.render(templateRule, activity, null, null);
    }

    @Override
    public void render(String templateId, Activity activity, Map<String, Object> model) {
        this.render(templateId, activity, model, null);
    }

    @Override
    public void render(String templateId, Activity activity, Writer writer) {
        this.render(templateId, activity, null, writer);
    }

    @Override
    public void render(TemplateRule templateRule, Activity activity, Map<String, Object> model) {
        this.render(templateRule, activity, model, null);
    }

    @Override
    public void render(String templateId, Activity activity, Map<String, Object> model, Writer writer) {
        if (templateId == null) {
            throw new IllegalArgumentException("templateId must not be null");
        }
        TemplateRule templateRule = this.templateRuleRegistry.getTemplateRule(templateId);
        if (templateRule == null) {
            throw new TemplateNotFoundException(templateId);
        }
        this.render(templateRule, activity, model, writer);
    }

    @Override
    public void render(TemplateRule templateRule, Activity activity, Map<String, Object> model, Writer writer) {
        try {
            if (activity == null) {
                activity = this.context.getAvailableActivity();
            }
            if (writer == null) {
                if (activity.getResponseAdapter() != null) {
                    writer = activity.getResponseAdapter().getWriter();
                }
                if (writer == null) {
                    throw new IllegalStateException("No such writer to transfer the output string");
                }
            }
            if (templateRule.isExternalEngine()) {
                TemplateEngine engine = null;
                if (templateRule.getEngineBeanClass() != null) {
                    engine = (TemplateEngine)activity.getBean(templateRule.getEngineBeanClass());
                } else if (templateRule.getEngineBeanId() != null) {
                    engine = (TemplateEngine)activity.getBean(templateRule.getEngineBeanId());
                }
                if (engine == null) {
                    throw new IllegalArgumentException("No template engine bean type for '" + templateRule.getEngine() + "'");
                }
                if (model == null) {
                    model = activity.getTranslet() != null ? activity.getTranslet().getActivityData() : new ActivityData(activity);
                }
                if (templateRule.isOutsourcing()) {
                    String templateName = templateRule.getName();
                    Locale locale = activity.getRequestAdapter() != null ? activity.getRequestAdapter().getLocale() : null;
                    engine.process(templateName, (Map<String, Object>)model, writer, locale);
                } else {
                    String templateSource = templateRule.getTemplateSource(this.context.getApplicationAdapter());
                    if (templateSource != null) {
                        Object templateName = templateRule.getId();
                        if (templateName == null) {
                            templateName = templateRule.getEngine() + "/" + templateRule.hashCode();
                        }
                        engine.process((String)templateName, (Map<String, Object>)model, templateSource, writer);
                    }
                }
            } else {
                Token[] templateTokens = templateRule.getTemplateTokens(this.context.getApplicationAdapter());
                if (templateTokens != null) {
                    TokenEvaluation evaluator = new TokenEvaluation(activity);
                    evaluator.evaluate(templateTokens, writer);
                } else {
                    writer.write(templateRule.getTemplateSource(this.context.getApplicationAdapter()));
                }
            }
        }
        catch (Exception e) {
            throw new TemplateRenderingException("An error occurred during rendering of the template", templateRule, e);
        }
    }

    @Override
    protected void doInitialize() throws Exception {
        this.templateRuleRegistry.initialize();
    }

    @Override
    protected void doDestroy() {
        this.templateRuleRegistry.destroy();
    }
}

