/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.translet;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.translet.scan.TransletScanFilter;
import com.aspectran.core.component.translet.scan.TransletScanner;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.expr.token.Tokenizer;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.RequestRule;
import com.aspectran.core.context.rule.ResponseRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.assistant.AssistantLocal;
import com.aspectran.core.context.rule.assistant.DefaultSettings;
import com.aspectran.core.context.rule.params.FilterParameters;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.core.util.ClassUtils;
import com.aspectran.core.util.PrefixSuffixPattern;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.core.util.wildcard.WildcardPattern;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TransletRuleRegistry
extends AbstractComponent {
    private static final Logger logger = LoggerFactory.getLogger(TransletRuleRegistry.class);
    private final Map<String, TransletRule> transletRuleMap = new LinkedHashMap<String, TransletRule>();
    private final Map<String, TransletRule> getTransletRuleMap = new HashMap<String, TransletRule>();
    private final Map<String, TransletRule> postTransletRuleMap = new HashMap<String, TransletRule>();
    private final Map<String, TransletRule> putTransletRuleMap = new HashMap<String, TransletRule>();
    private final Map<String, TransletRule> patchTransletRuleMap = new HashMap<String, TransletRule>();
    private final Map<String, TransletRule> deleteTransletRuleMap = new HashMap<String, TransletRule>();
    private final Comparator<TransletRule> comparator = new WeightComparator();
    private final Set<TransletRule> wildGetTransletRuleSet = new TreeSet<TransletRule>(this.comparator);
    private final Set<TransletRule> wildPostTransletRuleSet = new TreeSet<TransletRule>(this.comparator);
    private final Set<TransletRule> wildPutTransletRuleSet = new TreeSet<TransletRule>(this.comparator);
    private final Set<TransletRule> wildPatchTransletRuleSet = new TreeSet<TransletRule>(this.comparator);
    private final Set<TransletRule> wildDeleteTransletRuleSet = new TreeSet<TransletRule>(this.comparator);
    private final Set<TransletRule> etcTransletRuleSet = new TreeSet<TransletRule>(this.comparator);
    private final String basePath;
    private final ClassLoader classLoader;
    private AssistantLocal assistantLocal;

    public TransletRuleRegistry(ApplicationAdapter applicationAdapter) {
        this.basePath = applicationAdapter.getBasePath();
        this.classLoader = applicationAdapter.getClassLoader();
    }

    public void setAssistantLocal(AssistantLocal assistantLocal) {
        this.assistantLocal = assistantLocal;
    }

    public Collection<TransletRule> getTransletRules() {
        return this.transletRuleMap.values();
    }

    public TransletRule getTransletRule(String transletName) {
        return this.getTransletRule(transletName, MethodType.GET);
    }

    public TransletRule getTransletRule(String transletName, MethodType requestMethod) {
        TransletRule transletRule;
        if (transletName == null) {
            throw new IllegalArgumentException("transletName must not be null");
        }
        if (requestMethod == null) {
            throw new IllegalArgumentException("requestMethod must not be null");
        }
        switch (requestMethod) {
            case GET: {
                transletRule = this.getTransletRuleMap.get(transletName);
                if (transletRule != null) break;
                transletRule = this.lookupWildTransletRule(this.wildGetTransletRuleSet, transletName);
                break;
            }
            case POST: {
                transletRule = this.postTransletRuleMap.get(transletName);
                if (transletRule != null) break;
                transletRule = this.lookupWildTransletRule(this.wildPostTransletRuleSet, transletName);
                break;
            }
            case PUT: {
                transletRule = this.putTransletRuleMap.get(transletName);
                if (transletRule != null) break;
                transletRule = this.lookupWildTransletRule(this.wildPutTransletRuleSet, transletName);
                break;
            }
            case PATCH: {
                transletRule = this.patchTransletRuleMap.get(transletName);
                if (transletRule != null) break;
                transletRule = this.lookupWildTransletRule(this.wildPatchTransletRuleSet, transletName);
                break;
            }
            case DELETE: {
                transletRule = this.deleteTransletRuleMap.get(transletName);
                if (transletRule != null) break;
                transletRule = this.lookupWildTransletRule(this.wildDeleteTransletRuleSet, transletName);
                break;
            }
            default: {
                transletRule = this.lookupEtcTransletRule(transletName, requestMethod);
            }
        }
        if (transletRule == null && requestMethod != MethodType.GET && (transletRule = this.transletRuleMap.get(transletName)) == null) {
            transletRule = this.lookupWildTransletRule(this.wildGetTransletRuleSet, transletName);
        }
        return transletRule;
    }

    private TransletRule lookupWildTransletRule(Set<TransletRule> transletRuleSet, String transletName) {
        if (!transletRuleSet.isEmpty()) {
            for (TransletRule transletRule : transletRuleSet) {
                WildcardPattern namePattern = transletRule.getNamePattern();
                if (!(namePattern != null ? namePattern.matches(transletName) : transletName.equals(transletRule.getName()))) continue;
                return transletRule;
            }
        }
        return null;
    }

    private TransletRule lookupEtcTransletRule(String transletName, MethodType requestMethod) {
        if (!this.etcTransletRuleSet.isEmpty()) {
            for (TransletRule transletRule : this.etcTransletRuleSet) {
                WildcardPattern namePattern;
                if (!requestMethod.containsTo(transletRule.getAllowedMethods()) || !((namePattern = transletRule.getNamePattern()) != null ? namePattern.matches(transletName) : transletName.equals(transletRule.getName()))) continue;
                return transletRule;
            }
        }
        return null;
    }

    public boolean contains(String transletName) {
        return this.contains(transletName, MethodType.GET);
    }

    public boolean contains(String transletName, MethodType requestMethod) {
        return this.getTransletRule(transletName, requestMethod) != null;
    }

    public void addTransletRule(TransletRule transletRule) throws IllegalRuleException {
        if (transletRule == null) {
            throw new IllegalArgumentException("transletRule must not be null");
        }
        String scanPath = transletRule.getScanPath();
        if (scanPath != null) {
            TransletScanner scanner = this.createTransletScanner(transletRule);
            PrefixSuffixPattern prefixSuffixPattern = new PrefixSuffixPattern(transletRule.getName());
            scanner.scan(scanPath, (filePath, scannedFile) -> {
                TransletRule newTransletRule = TransletRule.replicate(transletRule, filePath);
                if (prefixSuffixPattern.isSplitted()) {
                    newTransletRule.setName(prefixSuffixPattern.join(filePath));
                } else if (transletRule.getName() != null) {
                    newTransletRule.setName(transletRule.getName() + filePath);
                }
                this.dissectTransletRule(newTransletRule);
            });
        } else {
            this.dissectTransletRule(transletRule);
        }
    }

    private TransletScanner createTransletScanner(TransletRule transletRule) throws IllegalRuleException {
        TransletScanner scanner = new TransletScanner(this.basePath);
        if (transletRule.getFilterParameters() != null) {
            String[] excludePatterns;
            FilterParameters filterParameters = transletRule.getFilterParameters();
            String transletScanFilterClassName = filterParameters.getString(FilterParameters.filterClass);
            if (transletScanFilterClassName != null) {
                TransletScanFilter transletScanFilter;
                try {
                    Class<?> filterClass = this.classLoader.loadClass(transletScanFilterClassName);
                    transletScanFilter = (TransletScanFilter)ClassUtils.createInstance(filterClass);
                }
                catch (Exception e) {
                    throw new IllegalRuleException("Failed to instantiate TransletScanFilter [" + transletScanFilterClassName + "]", e);
                }
                scanner.setTransletScanFilter(transletScanFilter);
            }
            if ((excludePatterns = filterParameters.getStringArray(FilterParameters.exclude)) != null) {
                scanner.setExcludePatterns(excludePatterns);
            }
        }
        if (transletRule.getMaskPattern() != null) {
            scanner.setTransletNameMaskPattern(transletRule.getMaskPattern());
        } else {
            scanner.setTransletNameMaskPattern(transletRule.getScanPath());
        }
        return scanner;
    }

    private void dissectTransletRule(TransletRule transletRule) {
        List<ResponseRule> responseRuleList;
        if (transletRule.getRequestRule() == null) {
            RequestRule requestRule = new RequestRule(false);
            transletRule.setRequestRule(requestRule);
        }
        if ((responseRuleList = transletRule.getResponseRuleList()) == null || responseRuleList.isEmpty()) {
            this.saveTransletRule(transletRule);
        } else if (responseRuleList.size() == 1) {
            transletRule.setResponseRule(responseRuleList.get(0));
            this.saveTransletRule(transletRule);
        } else {
            ResponseRule defaultResponseRule = null;
            for (ResponseRule responseRule : responseRuleList) {
                String responseName = responseRule.getName();
                if (responseName == null || responseName.isEmpty()) {
                    if (defaultResponseRule != null) {
                        logger.warn("Ignore duplicated default response rule " + defaultResponseRule + " of transletRule " + transletRule);
                    }
                    defaultResponseRule = responseRule;
                    continue;
                }
                TransletRule subTransletRule = transletRule.replicate();
                subTransletRule.setResponseRule(responseRule);
                this.saveTransletRule(subTransletRule);
            }
            if (defaultResponseRule != null) {
                transletRule.setResponseRule(defaultResponseRule);
                this.saveTransletRule(transletRule);
            }
        }
    }

    private void saveTransletRule(TransletRule transletRule) {
        transletRule.determineResponseRule();
        String transletName = this.applyTransletNamePattern(transletRule.getName());
        transletRule.setName(transletName);
        MethodType[] allowedMethods = transletRule.getAllowedMethods();
        if (this.hasPathVariables(transletName)) {
            this.savePathVariables(transletRule);
            if (allowedMethods != null) {
                String restfulTransletName = this.assembleTransletName(transletName, allowedMethods);
                this.transletRuleMap.put(restfulTransletName, transletRule);
                block14: for (MethodType methodType : allowedMethods) {
                    switch (methodType) {
                        case GET: {
                            this.wildGetTransletRuleSet.add(transletRule);
                            continue block14;
                        }
                        case POST: {
                            this.wildPostTransletRuleSet.add(transletRule);
                            continue block14;
                        }
                        case PUT: {
                            this.wildPutTransletRuleSet.add(transletRule);
                            continue block14;
                        }
                        case PATCH: {
                            this.wildPatchTransletRuleSet.add(transletRule);
                            continue block14;
                        }
                        case DELETE: {
                            this.wildDeleteTransletRuleSet.add(transletRule);
                            continue block14;
                        }
                        default: {
                            this.etcTransletRuleSet.add(transletRule);
                        }
                    }
                }
            } else {
                this.transletRuleMap.put(transletName, transletRule);
                this.wildGetTransletRuleSet.add(transletRule);
            }
        } else if (allowedMethods != null) {
            String restfulTransletName = this.assembleTransletName(transletName, allowedMethods);
            this.transletRuleMap.put(restfulTransletName, transletRule);
            block15: for (MethodType methodType : allowedMethods) {
                switch (methodType) {
                    case GET: {
                        this.getTransletRuleMap.put(transletName, transletRule);
                        continue block15;
                    }
                    case POST: {
                        this.postTransletRuleMap.put(transletName, transletRule);
                        continue block15;
                    }
                    case PUT: {
                        this.putTransletRuleMap.put(transletName, transletRule);
                        continue block15;
                    }
                    case PATCH: {
                        this.patchTransletRuleMap.put(transletName, transletRule);
                        continue block15;
                    }
                    case DELETE: {
                        this.deleteTransletRuleMap.put(transletName, transletRule);
                        continue block15;
                    }
                    default: {
                        this.etcTransletRuleSet.add(transletRule);
                    }
                }
            }
        } else {
            this.transletRuleMap.put(transletName, transletRule);
            this.getTransletRuleMap.put(transletName, transletRule);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("add TransletRule " + transletRule);
        }
    }

    private void savePathVariables(TransletRule transletRule) {
        String transletName = transletRule.getName();
        List<Token> tokenList = Tokenizer.tokenize(transletName, false);
        Token[] nameTokens = tokenList.toArray(new Token[0]);
        StringBuilder sb = new StringBuilder(transletName.length());
        for (Token token : nameTokens) {
            if (token.getType() == TokenType.PARAMETER || token.getType() == TokenType.ATTRIBUTE) {
                sb.append('*');
                continue;
            }
            String tokenString = token.stringify();
            sb.append(tokenString);
        }
        String wildTransletName = sb.toString();
        if (WildcardPattern.hasWildcards(wildTransletName)) {
            WildcardPattern namePattern = WildcardPattern.compile(wildTransletName, '/');
            transletRule.setNamePattern(namePattern);
            transletRule.setNameTokens(nameTokens);
        }
    }

    private boolean hasPathVariables(String transletName) {
        return (transletName.contains("${") || transletName.contains("@{")) && transletName.contains("}");
    }

    private String assembleTransletName(String transletName, MethodType[] allowedMethods) {
        if (allowedMethods != null) {
            if (allowedMethods.length > 1) {
                int len = transletName.length() + allowedMethods.length * 8;
                StringBuilder sb = new StringBuilder(len);
                for (MethodType type : allowedMethods) {
                    sb.append((Object)type).append(" ");
                }
                sb.append(transletName);
                return sb.toString();
            }
            if (allowedMethods.length == 1) {
                return this.assembleRestfulTransletName(transletName, allowedMethods[0]);
            }
        }
        return this.assembleRestfulTransletName(transletName, MethodType.GET);
    }

    private String assembleRestfulTransletName(String transletName, MethodType requestMethod) {
        return requestMethod + " " + transletName;
    }

    public String applyTransletNamePattern(String transletName) {
        return this.applyTransletNamePattern(transletName, false);
    }

    public String applyTransletNamePattern(String transletName, boolean absolutely) {
        DefaultSettings defaultSettings = this.assistantLocal.getDefaultSettings();
        if (defaultSettings == null) {
            return transletName;
        }
        if (defaultSettings.getTransletNamePrefix() == null && defaultSettings.getTransletNameSuffix() == null) {
            return transletName;
        }
        if (StringUtils.startsWith(transletName, '/')) {
            if (absolutely) {
                return transletName;
            }
            transletName = transletName.substring(1);
        }
        StringBuilder sb = new StringBuilder();
        if (defaultSettings.getTransletNamePrefix() != null) {
            sb.append(defaultSettings.getTransletNamePrefix());
        }
        if (transletName != null) {
            sb.append(transletName);
        }
        if (defaultSettings.getTransletNameSuffix() != null) {
            sb.append(defaultSettings.getTransletNameSuffix());
        }
        return sb.toString();
    }

    @Override
    protected void doInitialize() {
    }

    @Override
    protected void doDestroy() {
        this.transletRuleMap.clear();
        this.getTransletRuleMap.clear();
        this.postTransletRuleMap.clear();
        this.putTransletRuleMap.clear();
        this.patchTransletRuleMap.clear();
        this.deleteTransletRuleMap.clear();
        this.wildGetTransletRuleSet.clear();
        this.wildPostTransletRuleSet.clear();
        this.wildPutTransletRuleSet.clear();
        this.wildPatchTransletRuleSet.clear();
        this.wildDeleteTransletRuleSet.clear();
        this.etcTransletRuleSet.clear();
    }

    static class WeightComparator
    implements Comparator<TransletRule> {
        WeightComparator() {
        }

        @Override
        public int compare(TransletRule tr1, TransletRule tr2) {
            if (tr1.getNamePattern() != null && tr2.getNamePattern() != null) {
                float weight1 = tr1.getNamePattern().getWeight();
                float weight2 = tr2.getNamePattern().getWeight();
                int cmp = Float.compare(weight2, weight1);
                if (cmp == 0) {
                    cmp = tr1.getNamePattern().toString().compareTo(tr2.getNamePattern().toString());
                }
                return cmp;
            }
            if (tr1.getNamePattern() != null) {
                return tr2.getName().compareTo(tr1.getNamePattern().toString());
            }
            if (tr2.getNamePattern() != null) {
                return tr1.getName().compareTo(tr2.getNamePattern().toString());
            }
            return tr2.getName().compareTo(tr1.getName());
        }
    }
}

