/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.config;

import com.aspectran.core.context.config.ContextConfig;
import com.aspectran.core.context.config.DaemonConfig;
import com.aspectran.core.context.config.EmbedConfig;
import com.aspectran.core.context.config.SchedulerConfig;
import com.aspectran.core.context.config.ShellConfig;
import com.aspectran.core.context.config.SystemConfig;
import com.aspectran.core.context.config.WebConfig;
import com.aspectran.core.lang.NonNull;
import com.aspectran.core.lang.Nullable;
import com.aspectran.core.util.SystemUtils;
import com.aspectran.core.util.apon.AbstractParameters;
import com.aspectran.core.util.apon.AponReader;
import com.aspectran.core.util.apon.ParameterKey;
import com.aspectran.core.util.apon.VariableParameters;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;

public class AspectranConfig
extends AbstractParameters {
    public static final String BASE_PATH_PROPERTY_NAME = "aspectran.basePath";
    public static final String DEFAULT_ASPECTRAN_CONFIG_FILE = "aspectran-config.apon";
    public static final String DEFAULT_APP_CONFIG_ROOT_FILE = "classpath:app-config.xml";
    private static final ParameterKey system = new ParameterKey("system", SystemConfig.class);
    private static final ParameterKey context = new ParameterKey("context", ContextConfig.class);
    private static final ParameterKey scheduler = new ParameterKey("scheduler", SchedulerConfig.class);
    private static final ParameterKey embed = new ParameterKey("embed", EmbedConfig.class);
    private static final ParameterKey shell = new ParameterKey("shell", ShellConfig.class);
    private static final ParameterKey daemon = new ParameterKey("daemon", DaemonConfig.class);
    private static final ParameterKey web = new ParameterKey("web", WebConfig.class);
    private static final ParameterKey[] parameterKeys = new ParameterKey[]{system, context, scheduler, embed, shell, daemon, web};

    public AspectranConfig() {
        super(parameterKeys);
    }

    public AspectranConfig(String apon) throws IOException {
        this();
        this.readFrom(apon);
    }

    public AspectranConfig(@NonNull VariableParameters parameters) throws IOException {
        this(parameters.toString());
    }

    public AspectranConfig(File configFile) throws IOException {
        this();
        AponReader.parse(configFile, this);
    }

    public AspectranConfig(Reader reader) throws IOException {
        this();
        AponReader.parse(reader, this);
    }

    public SystemConfig getSystemConfig() {
        return (SystemConfig)this.getParameters(system);
    }

    public SystemConfig newSystemConfig() {
        return (SystemConfig)this.newParameters(system);
    }

    public SystemConfig touchSystemConfig() {
        return (SystemConfig)this.touchParameters(system);
    }

    public boolean hasSystemConfig() {
        return this.hasValue(system);
    }

    public ContextConfig getContextConfig() {
        return (ContextConfig)this.getParameters(context);
    }

    public ContextConfig newContextConfig() {
        return (ContextConfig)this.newParameters(context);
    }

    public ContextConfig touchContextConfig() {
        return (ContextConfig)this.touchParameters(context);
    }

    public boolean hasContextConfig() {
        return this.hasValue(context);
    }

    public SchedulerConfig getSchedulerConfig() {
        return (SchedulerConfig)this.getParameters(scheduler);
    }

    public SchedulerConfig newSchedulerConfig() {
        return (SchedulerConfig)this.newParameters(scheduler);
    }

    public SchedulerConfig touchSchedulerConfig() {
        return (SchedulerConfig)this.touchParameters(scheduler);
    }

    public EmbedConfig getEmbedConfig() {
        return (EmbedConfig)this.getParameters(embed);
    }

    public EmbedConfig newEmbedConfig() {
        return (EmbedConfig)this.newParameters(embed);
    }

    public EmbedConfig touchEmbedConfig() {
        return (EmbedConfig)this.touchParameters(embed);
    }

    public ShellConfig getShellConfig() {
        return (ShellConfig)this.getParameters(shell);
    }

    public ShellConfig newShellConfig() {
        return (ShellConfig)this.newParameters(shell);
    }

    public ShellConfig touchShellConfig() {
        return (ShellConfig)this.touchParameters(shell);
    }

    public DaemonConfig getDaemonConfig() {
        return (DaemonConfig)this.getParameters(daemon);
    }

    public DaemonConfig newDaemonConfig() {
        return (DaemonConfig)this.newParameters(daemon);
    }

    public DaemonConfig touchDaemonConfig() {
        return (DaemonConfig)this.touchParameters(daemon);
    }

    public WebConfig getWebConfig() {
        return (WebConfig)this.getParameters(web);
    }

    public WebConfig newWebConfig() {
        return (WebConfig)this.newParameters(web);
    }

    public WebConfig touchWebConfig() {
        return (WebConfig)this.touchParameters(web);
    }

    public static String determineBasePath(@Nullable String[] args) {
        String basePath = args == null || args.length < 2 ? SystemUtils.getProperty(BASE_PATH_PROPERTY_NAME) : args[0];
        if (basePath != null) {
            try {
                basePath = new File(basePath).getCanonicalPath();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to determine the base path", e);
            }
        }
        return basePath;
    }

    public static File determineAspectranConfigFile(@Nullable String[] args) {
        File file;
        String baseDir;
        if (args == null || args.length == 0) {
            baseDir = SystemUtils.getProperty(BASE_PATH_PROPERTY_NAME);
            file = baseDir != null ? new File(baseDir, DEFAULT_ASPECTRAN_CONFIG_FILE) : new File(DEFAULT_ASPECTRAN_CONFIG_FILE);
        } else if (args.length == 1) {
            baseDir = SystemUtils.getProperty(BASE_PATH_PROPERTY_NAME);
            if (baseDir != null) {
                Path basePath = Paths.get(baseDir, new String[0]);
                Path filePath = Paths.get(args[0], new String[0]);
                file = filePath.startsWith(basePath) && filePath.isAbsolute() ? filePath.toFile() : new File(baseDir, args[0]);
            } else {
                file = new File(args[0]);
            }
        } else {
            file = new File(args[0], args[1]);
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to determine the base path", e);
        }
    }
}

