/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.env;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.env.Environment;
import com.aspectran.core.context.env.EnvironmentProfiles;
import com.aspectran.core.context.expr.ItemEvaluation;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;

public class ActivityEnvironment
implements Environment {
    private final EnvironmentProfiles environmentProfiles;
    private final ActivityContext activityContext;
    private ItemRuleMap propertyItemRuleMap;

    public ActivityEnvironment(EnvironmentProfiles environmentProfiles, ActivityContext activityContext) {
        this.environmentProfiles = environmentProfiles;
        this.activityContext = activityContext;
    }

    @Override
    public String[] getActiveProfiles() {
        return this.environmentProfiles.getActiveProfiles();
    }

    @Override
    public String[] getDefaultProfiles() {
        return this.environmentProfiles.getDefaultProfiles();
    }

    @Override
    public boolean acceptsProfiles(String ... profiles) {
        return this.environmentProfiles.acceptsProfiles(profiles);
    }

    public ItemRuleMap getPropertyItemRuleMap() {
        return this.propertyItemRuleMap;
    }

    public void setPropertyItemRuleMap(ItemRuleMap propertyItemRuleMap) {
        this.propertyItemRuleMap = propertyItemRuleMap;
    }

    public void addPropertyItemRule(ItemRuleMap propertyItemRuleMap) {
        if (this.propertyItemRuleMap == null) {
            this.propertyItemRuleMap = new ItemRuleMap(propertyItemRuleMap);
        } else {
            this.propertyItemRuleMap.putAll(propertyItemRuleMap);
        }
    }

    @Override
    public <T> T getProperty(String name) {
        return this.getProperty(name, this.activityContext.getAvailableActivity());
    }

    @Override
    public <T> T getProperty(String name, Activity activity) {
        if (this.propertyItemRuleMap == null || this.propertyItemRuleMap.isEmpty()) {
            return null;
        }
        ItemRule itemRule = (ItemRule)this.propertyItemRuleMap.get(name);
        if (itemRule != null) {
            ItemEvaluation evaluator = new ItemEvaluation(activity);
            return (T)evaluator.evaluate(itemRule);
        }
        return null;
    }
}

