/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.env;

import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.SystemUtils;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.util.LinkedHashSet;
import java.util.Set;

public class EnvironmentProfiles {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentProfiles.class);
    public static final String ACTIVE_PROFILES_PROPERTY_NAME = "aspectran.profiles.active";
    public static final String DEFAULT_PROFILES_PROPERTY_NAME = "aspectran.profiles.default";
    private final Set<String> activeProfiles = new LinkedHashSet<String>();
    private final Set<String> defaultProfiles = new LinkedHashSet<String>();

    public String[] getActiveProfiles() {
        return this.activeProfiles.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> doGetActiveProfiles() {
        Set<String> set = this.activeProfiles;
        synchronized (set) {
            String[] profiles;
            if (this.activeProfiles.isEmpty() && (profiles = this.getProfilesFromSystemProperty(ACTIVE_PROFILES_PROPERTY_NAME)) != null) {
                this.setActiveProfiles(profiles);
                String[] activeProfiles = this.getActiveProfiles();
                if (activeProfiles.length > 0) {
                    logger.info("Activating profiles [" + StringUtils.joinCommaDelimitedList(activeProfiles) + "]");
                }
            }
            return this.activeProfiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveProfiles(String ... profiles) {
        if (profiles == null) {
            throw new IllegalArgumentException("profiles must not be null");
        }
        Set<String> set = this.activeProfiles;
        synchronized (set) {
            this.activeProfiles.clear();
            for (String profile : profiles) {
                this.validateProfile(profile);
                this.activeProfiles.add(profile);
            }
        }
    }

    public String[] getDefaultProfiles() {
        return this.defaultProfiles.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> doGetDefaultProfiles() {
        Set<String> set = this.defaultProfiles;
        synchronized (set) {
            String[] profiles;
            if (this.defaultProfiles.isEmpty() && (profiles = this.getProfilesFromSystemProperty(DEFAULT_PROFILES_PROPERTY_NAME)) != null) {
                this.setDefaultProfiles(profiles);
                String[] defaultProfiles = this.getDefaultProfiles();
                if (defaultProfiles.length > 0) {
                    logger.info("Default profiles [" + StringUtils.joinCommaDelimitedList(defaultProfiles) + "]");
                }
            }
            return this.defaultProfiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultProfiles(String ... profiles) {
        if (profiles == null) {
            throw new IllegalArgumentException("profiles must not be null");
        }
        Set<String> set = this.defaultProfiles;
        synchronized (set) {
            this.defaultProfiles.clear();
            for (String profile : profiles) {
                this.validateProfile(profile);
                this.defaultProfiles.add(profile);
            }
        }
    }

    public boolean acceptsProfiles(String ... profiles) {
        if (profiles == null || profiles.length == 0) {
            return true;
        }
        for (String profile : profiles) {
            if (!(StringUtils.hasLength(profile) && profile.charAt(0) == '!' ? !this.isProfileActive(profile.substring(1)) : this.isProfileActive(profile))) continue;
            return true;
        }
        return false;
    }

    private boolean isProfileActive(String profile) {
        this.validateProfile(profile);
        Set<String> currentActiveProfiles = this.doGetActiveProfiles();
        return currentActiveProfiles.contains(profile) || currentActiveProfiles.isEmpty() && this.doGetDefaultProfiles().contains(profile);
    }

    protected void validateProfile(String profile) {
        if (!StringUtils.hasText(profile)) {
            throw new IllegalArgumentException("Invalid profile [" + profile + "]: must contain text");
        }
        if (profile.charAt(0) == '!') {
            throw new IllegalArgumentException("Invalid profile [" + profile + "]: must not begin with ! operator");
        }
    }

    private String[] getProfilesFromSystemProperty(String propName) {
        String[] profiles;
        String profilesProp = SystemUtils.getProperty(propName);
        if (profilesProp != null && (profiles = StringUtils.splitCommaDelimitedString(profilesProp)).length > 0) {
            return profiles;
        }
        return null;
    }
}

