/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.expr;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityData;
import com.aspectran.core.context.expr.ExpressionEvaluationException;
import com.aspectran.core.context.expr.ExpressionEvaluator;
import com.aspectran.core.context.expr.ExpressionParserException;
import com.aspectran.core.context.expr.TokenEvaluation;
import com.aspectran.core.context.expr.TokenEvaluator;
import com.aspectran.core.context.expr.ognl.OgnlSupport;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.expr.token.TokenParser;
import com.aspectran.core.context.rule.type.TokenType;
import java.util.LinkedHashSet;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;

public class ExpressionEvaluation
implements ExpressionEvaluator {
    private static final String TOKEN_VAR_NAME_PREFIX = "__";
    private static final String TOKEN_VAR_NAME_SUFFIX = "__";
    private static final String TOKEN_VAR_REF_SYMBOL = "#";
    private static final String TOKEN_VAR_REF_NAME_PREFIX = "#__";
    private final String expression;
    private Object represented;
    private Token[] tokens;

    public ExpressionEvaluation(String expression) throws ExpressionParserException {
        this.expression = expression;
        this.parseExpression(expression);
    }

    public String getExpression() {
        return this.expression;
    }

    public Token[] getTokens() {
        return this.tokens;
    }

    @Override
    public <V> V evaluate(Activity activity, Class<V> resultType) {
        if (activity == null) {
            throw new IllegalArgumentException("activity must not be null");
        }
        if (this.represented == null) {
            return null;
        }
        try {
            ActivityData activityData = activity.getTranslet() != null ? activity.getTranslet().getActivityData() : new ActivityData(activity);
            OgnlContext ognlContext = OgnlSupport.createDefaultContext();
            String[] tokenVarNames = null;
            if (this.tokens != null && this.tokens.length > 0) {
                TokenEvaluation tokenEvaluator = new TokenEvaluation(activity);
                tokenVarNames = this.putTokenVariables(ognlContext, tokenEvaluator, this.tokens);
            }
            Object result = Ognl.getValue((Object)this.represented, (Map)ognlContext, (Object)activityData, resultType);
            if (tokenVarNames != null && result instanceof String) {
                String[] stringArray = tokenVarNames;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String str = (String)result;
                    String tokenVarName = stringArray[i];
                    String tokenVarRefName = TOKEN_VAR_REF_SYMBOL + tokenVarName;
                    if (!str.contains(tokenVarRefName)) continue;
                    Object value = ognlContext.get((Object)tokenVarName);
                    result = value != null ? str.replace(tokenVarRefName, value.toString()) : str.replace(tokenVarRefName, "");
                }
            }
            return (V)result;
        }
        catch (OgnlException e) {
            throw new ExpressionEvaluationException(this.expression, e);
        }
    }

    @Override
    public <V> V evaluate(TokenEvaluator tokenEvaluator, Class<V> resultType) {
        if (tokenEvaluator == null) {
            throw new IllegalArgumentException("tokenEvaluator must not be null");
        }
        if (this.represented == null) {
            return null;
        }
        try {
            Activity activity = tokenEvaluator.getActivity();
            ActivityData activityData = activity.getTranslet() != null ? activity.getTranslet().getActivityData() : new ActivityData(activity);
            OgnlContext ognlContext = OgnlSupport.createDefaultContext();
            String[] tokenVarNames = null;
            if (this.tokens != null && this.tokens.length > 0) {
                tokenVarNames = this.putTokenVariables(ognlContext, tokenEvaluator, this.tokens);
            }
            Object result = Ognl.getValue((Object)this.represented, (Map)ognlContext, (Object)activityData, resultType);
            if (tokenVarNames != null && result instanceof String) {
                String[] stringArray = tokenVarNames;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String str = (String)result;
                    String tokenVarName = stringArray[i];
                    String tokenVarRefName = TOKEN_VAR_REF_NAME_PREFIX + tokenVarName;
                    if (!str.contains(tokenVarRefName)) continue;
                    Object value = ognlContext.get((Object)tokenVarName);
                    result = value != null ? str.replace(tokenVarRefName, value.toString()) : str.replace(tokenVarRefName, "");
                }
            }
            return (V)result;
        }
        catch (OgnlException e) {
            throw new ExpressionEvaluationException(this.expression, e);
        }
    }

    private String[] putTokenVariables(OgnlContext ognlContext, TokenEvaluator tokenEvaluator, Token[] tokens) {
        LinkedHashSet<String> tokenVarNames = new LinkedHashSet<String>();
        for (Token token : tokens) {
            if (token.getType() == TokenType.TEXT) continue;
            String name = this.makeTokenVarName(token);
            Object value = tokenEvaluator.evaluate(token);
            ognlContext.put((Object)name, value);
            tokenVarNames.add(name);
        }
        return tokenVarNames.isEmpty() ? null : tokenVarNames.toArray(new String[0]);
    }

    private void parseExpression(String expression) throws ExpressionParserException {
        this.tokens = TokenParser.makeTokens(expression, true);
        if (this.tokens != null && this.tokens.length > 0) {
            if (this.tokens.length == 1) {
                Token token = this.tokens[0];
                if (token.getType() == TokenType.TEXT) {
                    this.represented = OgnlSupport.parseExpression(token.getDefaultValue());
                } else {
                    String ognlVariableName = this.makeTokenVarRefName(token);
                    this.represented = OgnlSupport.parseExpression(ognlVariableName);
                }
            } else {
                StringBuilder sb = new StringBuilder();
                for (Token token : this.tokens) {
                    if (token.getType() == TokenType.TEXT) {
                        sb.append(token.getDefaultValue());
                        continue;
                    }
                    sb.append(this.makeTokenVarRefName(token));
                }
                this.represented = OgnlSupport.parseExpression(sb.toString());
            }
        } else {
            this.represented = OgnlSupport.parseExpression(expression);
        }
    }

    private String makeTokenVarName(Token token) {
        return "__" + this.makeTokenName(token) + "__";
    }

    private String makeTokenVarRefName(Token token) {
        return TOKEN_VAR_REF_NAME_PREFIX + this.makeTokenName(token) + "__";
    }

    private String makeTokenName(Token token) {
        int hashCode = token.hashCode();
        if (hashCode >= 0) {
            return Long.toString(hashCode, 32);
        }
        return Long.toString(hashCode & Integer.MAX_VALUE, 32);
    }
}

