/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.resource;

import com.aspectran.core.context.resource.InvalidResourceException;
import com.aspectran.core.context.resource.LocalResourceManager;
import com.aspectran.core.context.resource.ResourceManager;
import com.aspectran.core.util.ClassUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class AspectranClassLoader
extends ClassLoader {
    private final int id;
    private final AspectranClassLoader root;
    private final String resourceLocation;
    private final ResourceManager resourceManager;
    private final List<AspectranClassLoader> children = new LinkedList<AspectranClassLoader>();
    private final boolean firstborn;
    private int reloadedCount;
    private Set<String> excludeClassNames;
    private Set<String> excludePackageNames;

    public AspectranClassLoader() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public AspectranClassLoader(ClassLoader parent) {
        super(parent);
        this.id = 1000;
        this.root = this;
        this.firstborn = true;
        this.resourceLocation = null;
        this.resourceManager = new LocalResourceManager(this);
    }

    public AspectranClassLoader(String resourceLocation) throws InvalidResourceException {
        this(resourceLocation, ClassUtils.getDefaultClassLoader());
    }

    public AspectranClassLoader(String resourceLocation, ClassLoader parent) throws InvalidResourceException {
        super(parent);
        this.id = 1000;
        this.root = this;
        this.firstborn = true;
        this.resourceLocation = resourceLocation;
        this.resourceManager = new LocalResourceManager(resourceLocation, this);
    }

    public AspectranClassLoader(String[] resourceLocations) throws InvalidResourceException {
        this(resourceLocations, ClassUtils.getDefaultClassLoader());
    }

    public AspectranClassLoader(String[] resourceLocations, ClassLoader parent) throws InvalidResourceException {
        this(parent);
        AspectranClassLoader acl = this;
        for (String resourceLocation : resourceLocations) {
            acl = acl.createChild(resourceLocation);
        }
    }

    protected AspectranClassLoader(String resourceLocation, AspectranClassLoader parent) throws InvalidResourceException {
        super(parent);
        int numOfChildren = parent.addChild(this);
        this.id = (Math.abs(parent.getId() / 1000) + 1) * 1000 + numOfChildren;
        this.root = parent.getRoot();
        this.firstborn = numOfChildren == 1;
        this.resourceLocation = resourceLocation;
        this.resourceManager = new LocalResourceManager(resourceLocation, this);
    }

    private AspectranClassLoader(ClassLoader parent, AspectranClassLoader latest) {
        super(parent);
        int numOfChildren = latest.addChild(this);
        this.id = (Math.abs(latest.getId() / 1000) + 1) * 1000 + numOfChildren;
        this.root = latest;
        this.firstborn = numOfChildren == 1;
        this.resourceLocation = null;
        this.resourceManager = new LocalResourceManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceLocations(String ... resourceLocations) throws InvalidResourceException {
        List<AspectranClassLoader> list = this.children;
        synchronized (list) {
            if (!this.children.isEmpty()) {
                this.children.clear();
            }
            AspectranClassLoader acl = this;
            for (String resourceLocation : resourceLocations) {
                if (resourceLocation == null || resourceLocation.isEmpty()) continue;
                acl = acl.createChild(resourceLocation);
            }
        }
    }

    public AspectranClassLoader addGeneration(ClassLoader classLoader) {
        AspectranClassLoader latest = this.root;
        while (latest.hasChildren()) {
            latest = latest.getChildren().get(0);
        }
        return new AspectranClassLoader(classLoader, latest);
    }

    protected AspectranClassLoader joinBrother(String resourceLocation) throws InvalidResourceException {
        AspectranClassLoader parent = (AspectranClassLoader)this.getParent();
        return parent.createChild(resourceLocation);
    }

    private AspectranClassLoader createChild(String resourceLocation) throws InvalidResourceException {
        if (!this.firstborn) {
            throw new IllegalStateException("Only the firstborn AspectranClassLoader can create a child");
        }
        return new AspectranClassLoader(resourceLocation, this);
    }

    public void excludePackage(String ... packageNames) {
        if (packageNames == null) {
            this.excludePackageNames = null;
        } else {
            for (String packageName : packageNames) {
                if (this.excludePackageNames == null) {
                    this.excludePackageNames = new HashSet<String>();
                }
                this.excludePackageNames.add(packageName + ".");
            }
        }
    }

    public void excludeClass(String ... classNames) {
        if (classNames == null) {
            this.excludeClassNames = null;
        } else {
            for (String className : classNames) {
                if (this.isExcludePackage(className)) continue;
                if (this.excludeClassNames == null) {
                    this.excludeClassNames = new HashSet<String>();
                }
                this.excludeClassNames.add(className);
            }
        }
    }

    private boolean isExcluded(String className) {
        return this.isExcludePackage(className) || this.isExcludeClass(className);
    }

    private boolean isExcludePackage(String className) {
        if (this.excludePackageNames != null) {
            for (String packageName : this.excludePackageNames) {
                if (!className.startsWith(packageName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isExcludeClass(String className) {
        return this.excludeClassNames != null && this.excludeClassNames.contains(className);
    }

    public int getId() {
        return this.id;
    }

    public AspectranClassLoader getRoot() {
        return this.root;
    }

    public boolean isRoot() {
        return this == this.root;
    }

    public List<AspectranClassLoader> getChildren() {
        return this.children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addChild(AspectranClassLoader child) {
        List<AspectranClassLoader> list = this.children;
        synchronized (list) {
            this.children.add(child);
            return this.children.size();
        }
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean isFirstborn() {
        return this.firstborn;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public synchronized void reload() throws InvalidResourceException {
        this.reload(this.root);
    }

    private void reload(AspectranClassLoader self) throws InvalidResourceException {
        self.increaseReloadedCount();
        if (self.getResourceManager() != null) {
            self.getResourceManager().reset();
        }
        AspectranClassLoader firstborn = null;
        ArrayList<AspectranClassLoader> brothers = new ArrayList<AspectranClassLoader>();
        for (AspectranClassLoader child : self.getChildren()) {
            if (child.isFirstborn()) {
                firstborn = child;
                continue;
            }
            brothers.add(child);
        }
        if (!brothers.isEmpty()) {
            self.leave(brothers);
        }
        if (firstborn != null) {
            this.reload(firstborn);
        }
    }

    private void increaseReloadedCount() {
        ++this.reloadedCount;
    }

    private void leave(List<AspectranClassLoader> brothers) {
        for (AspectranClassLoader acl : brothers) {
            ResourceManager rm = acl.getResourceManager();
            if (rm != null) {
                rm.release();
            }
            this.children.remove(acl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            int index22;
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            ClassLoader system = AspectranClassLoader.getSystemClassLoader();
            try {
                c = system.loadClass(name);
                if (c != null) {
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                Policy policy = Policy.getPolicy();
                policy.refresh();
            }
            catch (AccessControlException policy) {
                // empty catch block
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (index22 = name.lastIndexOf(46)) >= 0) {
                try {
                    securityManager.checkPackageAccess(name.substring(0, index22));
                }
                catch (SecurityException se) {
                    String error = "Security Violation, attempt to use Restricted Class: " + name;
                    throw new ClassNotFoundException(error, se);
                }
            }
            try {
                c = this.findClass(name);
                if (c != null) {
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
            }
            catch (ClassNotFoundException index22) {
                // empty catch block
            }
            ClassLoader loader = this.root.getParent();
            if (loader == null) {
                loader = system;
            }
            try {
                c = Class.forName(name, false, loader);
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Objects.requireNonNull(name);
        try {
            byte[] classData = this.loadClassData(name);
            if (classData != null) {
                return this.defineClass(name, classData, 0, classData.length);
            }
            throw new ClassNotFoundException(name);
        }
        catch (InvalidResourceException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    private byte[] loadClassData(String className) throws InvalidResourceException {
        if (this.isExcluded(className)) {
            return null;
        }
        String resourceName = AspectranClassLoader.classNameToResourceName(className);
        Enumeration<URL> res = ResourceManager.getResources(this.getAllMembers(), resourceName);
        URL url = null;
        if (res.hasMoreElements()) {
            url = res.nextElement();
        }
        if (url == null) {
            return null;
        }
        try {
            int len;
            URLConnection connection = url.openConnection();
            InputStream input = connection.getInputStream();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((len = input.read(buffer)) >= 0) {
                output.write(buffer, 0, len);
            }
            input.close();
            return output.toByteArray();
        }
        catch (IOException e) {
            throw new InvalidResourceException("Unable to read class file: " + url, e);
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Objects.requireNonNull(name);
        Enumeration<URL> parentResources = null;
        ClassLoader parent = this.root.getParent();
        if (parent != null) {
            parentResources = parent.getResources(name);
        }
        return ResourceManager.getResources(this.getAllMembers(), name, parentResources);
    }

    @Override
    public URL findResource(String name) {
        Objects.requireNonNull(name);
        URL url = null;
        Enumeration<URL> res = ResourceManager.getResources(this.getAllMembers(), name);
        if (res.hasMoreElements()) {
            url = res.nextElement();
        }
        return url;
    }

    @Override
    public Enumeration<URL> findResources(String name) {
        Objects.requireNonNull(name);
        LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        Enumeration<URL> res = ResourceManager.getResources(this.getAllMembers(), name);
        if (res.hasMoreElements()) {
            result.add(res.nextElement());
        }
        return Collections.enumeration(result);
    }

    public Iterator<AspectranClassLoader> getAllMembers() {
        return AspectranClassLoader.getMembers(this.root);
    }

    public Enumeration<URL> getAllResources() {
        return ResourceManager.getResources(this.getAllMembers());
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("id", this.id);
        if (this.getParent() instanceof AspectranClassLoader) {
            tsb.append("parent", ((AspectranClassLoader)this.getParent()).getId());
        } else {
            tsb.append("parent", this.getParent().getClass().getName());
        }
        tsb.append("root", this == this.root);
        tsb.append("firstborn", this.firstborn);
        tsb.append("resourceLocation", this.resourceLocation);
        tsb.append("numberOfResource", this.resourceManager.getNumberOfResources());
        tsb.appendSize("numberOfChildren", this.children);
        tsb.append("reloadedCount", this.reloadedCount);
        return tsb.toString();
    }

    public static Iterator<AspectranClassLoader> getMembers(final AspectranClassLoader root) {
        return new Iterator<AspectranClassLoader>(){
            private AspectranClassLoader next;
            private Iterator<AspectranClassLoader> children;
            private AspectranClassLoader firstChild;
            {
                this.next = root;
                this.children = root.getChildren().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public AspectranClassLoader next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                AspectranClassLoader current = this.next;
                if (this.children.hasNext()) {
                    this.next = this.children.next();
                    if (this.firstChild == null) {
                        this.firstChild = this.next;
                    }
                } else if (this.firstChild != null) {
                    this.children = this.firstChild.getChildren().iterator();
                    if (this.children.hasNext()) {
                        this.firstChild = this.next = this.children.next();
                    } else {
                        this.next = null;
                    }
                } else {
                    this.next = null;
                }
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public static String resourceNameToClassName(String resourceName) {
        String className = resourceName.substring(0, resourceName.length() - ".class".length());
        className = className.replace('/', '.');
        return className;
    }

    public static String classNameToResourceName(String className) {
        return className.replace('.', '/') + ".class";
    }

    public static String packageNameToResourceName(String packageName) {
        String resourceName = packageName.replace('.', '/');
        if (StringUtils.endsWith(resourceName, '/')) {
            resourceName = resourceName.substring(0, resourceName.length() - 1);
        }
        return resourceName;
    }

    public static String[] checkResourceLocations(String[] resourceLocations, String basePath) throws InvalidResourceException {
        if (resourceLocations == null) {
            return null;
        }
        ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
        for (int i = 0; i < resourceLocations.length; ++i) {
            if (resourceLocations[i].startsWith("classpath:")) {
                String path = resourceLocations[i].substring("classpath:".length());
                URL url = classLoader.getResource(path);
                if (url == null) {
                    throw new InvalidResourceException("Class path resource [" + resourceLocations[i] + "] cannot be resolved to URL because it does not exist");
                }
                resourceLocations[i] = url.getFile();
            } else {
                if (resourceLocations[i].startsWith("file:")) {
                    try {
                        URL url = new URL(resourceLocations[i]);
                        resourceLocations[i] = url.getFile();
                    }
                    catch (MalformedURLException e) {
                        throw new InvalidResourceException("Resource location [" + resourceLocations[i] + "] is neither a URL not a well-formed file path");
                    }
                }
                if (basePath != null) {
                    try {
                        File f = new File(basePath, resourceLocations[i]);
                        resourceLocations[i] = f.getCanonicalPath();
                    }
                    catch (IOException e) {
                        throw new InvalidResourceException("Invalid resource location: " + resourceLocations[i], e);
                    }
                }
            }
            resourceLocations[i] = resourceLocations[i].replace(File.separatorChar, '/');
            if (!StringUtils.endsWith(resourceLocations[i], '/')) continue;
            resourceLocations[i] = resourceLocations[i].substring(0, resourceLocations[i].length() - 1);
        }
        String resourceLocation = null;
        int cleared = 0;
        try {
            for (int i = 0; i < resourceLocations.length - 1; ++i) {
                if (resourceLocations[i] == null) continue;
                resourceLocation = resourceLocations[i];
                File f1 = new File(resourceLocations[i]);
                String l1 = f1.getCanonicalPath();
                for (int j = i + 1; j < resourceLocations.length; ++j) {
                    if (resourceLocations[j] == null) continue;
                    resourceLocation = resourceLocations[j];
                    File f2 = new File(resourceLocations[j]);
                    String l2 = f2.getCanonicalPath();
                    if (!l1.equals(l2)) continue;
                    resourceLocations[j] = null;
                    ++cleared;
                }
            }
        }
        catch (IOException e) {
            throw new InvalidResourceException("Invalid resource location: " + resourceLocation, e);
        }
        if (cleared > 0) {
            ArrayList<String> list = new ArrayList<String>(resourceLocations.length);
            for (String r : resourceLocations) {
                if (r == null) continue;
                list.add(r);
            }
            return list.toArray(new String[0]);
        }
        return resourceLocations;
    }
}

