/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.ToStringBuilder;

public class EchoActionRule {
    private String actionId;
    private ItemRuleMap echoItemRuleMap;
    private Boolean hidden;

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public ItemRuleMap getEchoItemRuleMap() {
        return this.echoItemRuleMap;
    }

    public void setEchoItemRuleMap(ItemRuleMap echoItemRuleMap) {
        this.echoItemRuleMap = echoItemRuleMap;
    }

    public ItemRule newEchoItemRule(String echoName) {
        ItemRule itemRule = new ItemRule();
        itemRule.setName(echoName);
        this.addEchoItemRule(itemRule);
        return itemRule;
    }

    public void addEchoItemRule(ItemRule itemRule) {
        if (this.echoItemRuleMap == null) {
            this.echoItemRuleMap = new ItemRuleMap();
        }
        this.echoItemRuleMap.putItemRule(itemRule);
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public boolean isHidden() {
        return BooleanUtils.toBoolean(this.hidden);
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("id", this.actionId);
        if (this.echoItemRuleMap != null) {
            tsb.append("attributes", this.echoItemRuleMap.keySet());
        }
        tsb.append("hidden", this.hidden);
        return tsb.toString();
    }

    public static EchoActionRule newInstance(String id, Boolean hidden) {
        EchoActionRule echoActionRule = new EchoActionRule();
        echoActionRule.setActionId(id);
        echoActionRule.setHidden(hidden);
        return echoActionRule;
    }
}

