/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.ability.Replicable;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.ToStringBuilder;

public class ForwardRule
implements Replicable<ForwardRule> {
    public static final ResponseType RESPONSE_TYPE = ResponseType.FORWARD;
    private String contentType;
    private String transletName;
    private MethodType requestMethod;
    private ItemRuleMap attributeItemRuleMap;
    private Boolean defaultResponse;

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getTransletName() {
        return this.transletName;
    }

    public void setTransletName(String transletName) {
        this.transletName = transletName;
    }

    public MethodType getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(MethodType requestMethod) {
        this.requestMethod = requestMethod;
    }

    public ItemRuleMap getAttributeItemRuleMap() {
        return this.attributeItemRuleMap;
    }

    public void setAttributeItemRuleMap(ItemRuleMap attributeItemRuleMap) {
        this.attributeItemRuleMap = attributeItemRuleMap;
    }

    public ItemRule newAttributeItemRule(String attributeName) {
        ItemRule itemRule = new ItemRule();
        itemRule.setName(attributeName);
        this.addAttributeItemRule(itemRule);
        return itemRule;
    }

    public void addAttributeItemRule(ItemRule itemRule) {
        if (this.attributeItemRuleMap == null) {
            this.attributeItemRuleMap = new ItemRuleMap();
        }
        this.attributeItemRuleMap.putItemRule(itemRule);
    }

    public Boolean getDefaultResponse() {
        return this.defaultResponse;
    }

    public boolean isDefaultResponse() {
        return BooleanUtils.toBoolean(this.defaultResponse);
    }

    public void setDefaultResponse(Boolean defaultResponse) {
        this.defaultResponse = defaultResponse;
    }

    @Override
    public ForwardRule replicate() {
        return ForwardRule.replicate(this);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.appendForce("type", (Object)RESPONSE_TYPE);
        tsb.append("translet", this.transletName);
        tsb.append("method", (Object)this.requestMethod);
        tsb.append("contentType", this.contentType);
        tsb.append("default", this.getDefaultResponse());
        return tsb.toString();
    }

    public static ForwardRule newInstance(String contentType, String transletName, String method, Boolean defaultResponse) throws IllegalRuleException {
        if (transletName == null) {
            throw new IllegalRuleException("The 'forward' element requires a 'translet' attribute");
        }
        MethodType requestMethod = null;
        if (method != null && (requestMethod = MethodType.resolve(method)) == null) {
            throw new IllegalRuleException("No request method type for '" + method + "'");
        }
        ForwardRule fr = new ForwardRule();
        fr.setContentType(contentType);
        fr.setTransletName(transletName);
        fr.setRequestMethod(requestMethod);
        fr.setDefaultResponse(defaultResponse);
        return fr;
    }

    public static ForwardRule newInstance(String transletName) throws IllegalRuleException {
        if (transletName == null) {
            throw new IllegalRuleException("transletName must not be null");
        }
        ForwardRule fr = new ForwardRule();
        fr.setTransletName(transletName);
        return fr;
    }

    public static ForwardRule replicate(ForwardRule forwardRule) {
        ForwardRule fr = new ForwardRule();
        fr.setContentType(forwardRule.getContentType());
        fr.setTransletName(forwardRule.getTransletName());
        fr.setAttributeItemRuleMap(forwardRule.getAttributeItemRuleMap());
        fr.setDefaultResponse(forwardRule.getDefaultResponse());
        return fr;
    }
}

