/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.ToStringBuilder;

public class HeaderActionRule {
    private String actionId;
    private ItemRuleMap headerItemRuleMap;
    private Boolean hidden;

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public ItemRuleMap getHeaderItemRuleMap() {
        return this.headerItemRuleMap;
    }

    public void setHeaderItemRuleMap(ItemRuleMap headerItemRuleMap) {
        this.headerItemRuleMap = headerItemRuleMap;
    }

    public ItemRule newHeaderItemRule(String headerName) {
        ItemRule itemRule = new ItemRule();
        itemRule.setName(headerName);
        this.addHeaderItemRule(itemRule);
        return itemRule;
    }

    public void addHeaderItemRule(ItemRule headerItemRule) {
        if (this.headerItemRuleMap == null) {
            this.headerItemRuleMap = new ItemRuleMap();
        }
        this.headerItemRuleMap.putItemRule(headerItemRule);
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public boolean isHidden() {
        return BooleanUtils.toBoolean(this.hidden, true);
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("id", this.actionId);
        if (this.headerItemRuleMap != null) {
            tsb.append("headers", this.headerItemRuleMap.keySet());
        }
        tsb.append("hidden", this.hidden);
        return tsb.toString();
    }

    public static HeaderActionRule newInstance(String id, Boolean hidden) {
        HeaderActionRule headerActionRule = new HeaderActionRule();
        headerActionRule.setActionId(id);
        headerActionRule.setHidden(hidden);
        return headerActionRule;
    }
}

