/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.PointcutPatternRule;
import com.aspectran.core.context.rule.PointcutRule;
import com.aspectran.core.context.rule.params.JoinpointParameters;
import com.aspectran.core.context.rule.params.PointcutParameters;
import com.aspectran.core.context.rule.params.PointcutQualifierParameters;
import com.aspectran.core.context.rule.type.JoinpointTargetType;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JoinpointRule {
    private JoinpointTargetType joinpointTargetType;
    private MethodType[] methods;
    private String[] headers;
    private PointcutRule pointcutRule;
    private JoinpointParameters joinpointParameters;

    public JoinpointTargetType getJoinpointTargetType() {
        return this.joinpointTargetType;
    }

    public void setJoinpointTargetType(JoinpointTargetType joinpointTargetType) {
        this.joinpointTargetType = joinpointTargetType;
        if (this.joinpointParameters != null) {
            if (joinpointTargetType != null) {
                this.joinpointParameters.putValue(JoinpointParameters.target, (Object)joinpointTargetType.toString());
            } else {
                this.joinpointParameters.putValue(JoinpointParameters.target, null);
            }
        }
    }

    public MethodType[] getMethods() {
        return this.methods;
    }

    public void setMethods(MethodType[] methods) {
        this.methods = methods;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
    }

    public PointcutRule getPointcutRule() {
        return this.pointcutRule;
    }

    public void setPointcutRule(PointcutRule pointcutRule) {
        this.pointcutRule = pointcutRule;
    }

    public JoinpointParameters getJoinpointParameters() {
        return this.joinpointParameters;
    }

    private void setJoinpointParameters(JoinpointParameters joinpointParameters) {
        this.joinpointParameters = joinpointParameters;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("target", (Object)this.joinpointTargetType);
        tsb.append("methods", this.methods);
        tsb.append("headers", this.headers);
        tsb.append("pointcut", this.pointcutRule);
        return tsb.toString();
    }

    public static JoinpointRule newInstance() {
        return new JoinpointRule();
    }

    public static void updateJoinpoint(JoinpointRule joinpointRule, String apon) throws IllegalRuleException {
        if (StringUtils.hasText(apon)) {
            JoinpointParameters joinpointParameters;
            try {
                joinpointParameters = new JoinpointParameters(apon);
            }
            catch (IOException e) {
                throw new IllegalRuleException("Joinpoint parameter can not be parsed", e);
            }
            JoinpointRule.updateJoinpoint(joinpointRule, joinpointParameters);
        }
    }

    public static void updateJoinpoint(JoinpointRule joinpointRule, JoinpointParameters joinpointParameters) throws IllegalRuleException {
        if (joinpointRule.getJoinpointTargetType() == null) {
            String target = joinpointParameters.getString(JoinpointParameters.target);
            JoinpointRule.updateJoinpointTargetType(joinpointRule, target);
        }
        JoinpointRule.updateMethods(joinpointRule, joinpointParameters.getStringArray(JoinpointParameters.methods));
        JoinpointRule.updateHeaders(joinpointRule, joinpointParameters.getStringArray(JoinpointParameters.headers));
        JoinpointRule.updatePointcutRule(joinpointRule, (PointcutParameters)joinpointParameters.getParameters(JoinpointParameters.pointcut));
        joinpointRule.setJoinpointParameters(joinpointParameters);
    }

    public static void updateJoinpointTargetType(JoinpointRule joinpointRule, String target) {
        if (target != null) {
            JoinpointTargetType joinpointTargetType = JoinpointTargetType.resolve(target);
            if (joinpointTargetType == null) {
                throw new IllegalArgumentException("No joinpoint target type for '" + target + "'");
            }
            joinpointRule.setJoinpointTargetType(joinpointTargetType);
        }
    }

    public static void updateMethods(JoinpointRule joinpointRule, String[] methods) {
        if (methods != null && methods.length > 0) {
            ArrayList<MethodType> methodTypes = new ArrayList<MethodType>(methods.length);
            for (String method : methods) {
                MethodType methodType = MethodType.resolve(method);
                if (methodType == null) {
                    throw new IllegalArgumentException("No request method type for '" + method + "'");
                }
                methodTypes.add(methodType);
            }
            if (!methodTypes.isEmpty()) {
                joinpointRule.setMethods(methodTypes.toArray(new MethodType[0]));
            }
        }
    }

    public static void updateHeaders(JoinpointRule joinpointRule, String[] headers) {
        if (headers != null && headers.length > 0) {
            ArrayList<String> headerList = new ArrayList<String>(headers.length);
            for (String header : headers) {
                if (!StringUtils.hasText(header)) continue;
                headerList.add(header);
            }
            if (!headerList.isEmpty()) {
                joinpointRule.setHeaders(headerList.toArray(new String[0]));
            }
        }
    }

    public static void updatePointcutRule(JoinpointRule joinpointRule, PointcutParameters pointcutParameters) throws IllegalRuleException {
        if (pointcutParameters == null) {
            return;
        }
        List<String> plusPatternStringList = pointcutParameters.getStringList(PointcutParameters.plus);
        List<String> minusPatternStringList = pointcutParameters.getStringList(PointcutParameters.minus);
        List<PointcutQualifierParameters> includeQualifierParametersList = pointcutParameters.getParametersList(PointcutParameters.include);
        List<PointcutQualifierParameters> excludeQualifierParametersList = pointcutParameters.getParametersList(PointcutParameters.exclude);
        List<PointcutPatternRule> pointcutPatternRuleList = JoinpointRule.mergePointcutPatternRules(plusPatternStringList, includeQualifierParametersList);
        List<PointcutPatternRule> excludePointcutPatternRuleList = JoinpointRule.mergePointcutPatternRules(minusPatternStringList, excludeQualifierParametersList);
        if (pointcutPatternRuleList == null && excludePointcutPatternRuleList == null) {
            return;
        }
        PointcutRule pointcutRule = PointcutRule.newInstance(pointcutParameters.getString(PointcutParameters.type));
        if (pointcutPatternRuleList != null) {
            for (PointcutPatternRule pointcutPatternRule : pointcutPatternRuleList) {
                pointcutPatternRule.setExcludePointcutPatternRuleList(excludePointcutPatternRuleList);
                pointcutRule.addPointcutPatternRule(pointcutPatternRule);
            }
        } else {
            PointcutPatternRule pointcutPatternRule = new PointcutPatternRule();
            pointcutPatternRule.setExcludePointcutPatternRuleList(excludePointcutPatternRuleList);
            pointcutRule.addPointcutPatternRule(pointcutPatternRule);
        }
        joinpointRule.setPointcutRule(pointcutRule);
    }

    private static List<PointcutPatternRule> mergePointcutPatternRules(List<String> patternStringList, List<PointcutQualifierParameters> qualifierParametersList) {
        PointcutPatternRule pointcutPatternRule;
        int qualifierParametersSize;
        int patternStringSize = patternStringList != null ? patternStringList.size() : 0;
        int n = qualifierParametersSize = qualifierParametersList != null ? qualifierParametersList.size() : 0;
        if (patternStringSize == 0 && qualifierParametersSize == 0) {
            return null;
        }
        ArrayList<PointcutPatternRule> pointcutPatternRuleList = new ArrayList<PointcutPatternRule>(patternStringSize + qualifierParametersSize);
        if (patternStringSize > 0) {
            for (String patternString : patternStringList) {
                pointcutPatternRule = PointcutPatternRule.newInstance(patternString);
                pointcutPatternRuleList.add(pointcutPatternRule);
            }
        }
        if (qualifierParametersSize > 0) {
            for (PointcutQualifierParameters includeQualifierParameters : qualifierParametersList) {
                pointcutPatternRule = JoinpointRule.createPointcutPatternRule(includeQualifierParameters);
                pointcutPatternRuleList.add(pointcutPatternRule);
            }
        }
        return pointcutPatternRuleList;
    }

    private static PointcutPatternRule createPointcutPatternRule(PointcutQualifierParameters pointcutQualifierParameters) {
        PointcutPatternRule pointcutPatternRule = null;
        String translet = pointcutQualifierParameters.getString(PointcutQualifierParameters.translet);
        String bean = pointcutQualifierParameters.getString(PointcutQualifierParameters.bean);
        String method = pointcutQualifierParameters.getString(PointcutQualifierParameters.method);
        if (StringUtils.hasLength(translet) || StringUtils.hasLength(bean) || StringUtils.hasLength(method)) {
            pointcutPatternRule = PointcutPatternRule.newInstance(translet, bean, method);
        }
        return pointcutPatternRule;
    }
}

