/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.appender;

import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.appender.AbstractAppendHandler;
import com.aspectran.core.context.rule.appender.FileRuleAppender;
import com.aspectran.core.context.rule.appender.RuleAppender;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.assistant.AssistantLocal;
import com.aspectran.core.context.rule.assistant.ShallowContextRuleAssistant;
import com.aspectran.core.context.rule.converter.ParametersToRules;
import com.aspectran.core.context.rule.converter.RulesToParameters;
import com.aspectran.core.context.rule.params.AspectranParameters;
import com.aspectran.core.context.rule.params.RootParameters;
import com.aspectran.core.context.rule.parser.xml.AspectranDtdResolver;
import com.aspectran.core.context.rule.parser.xml.AspectranNodeParser;
import com.aspectran.core.context.rule.type.AppendableFileFormatType;
import com.aspectran.core.context.rule.type.AppenderType;
import com.aspectran.core.util.apon.AponWriter;
import com.aspectran.core.util.apon.XmlToApon;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.xml.sax.EntityResolver;

public class HybridRuleAppendHandler
extends AbstractAppendHandler {
    private final String encoding;
    private AspectranNodeParser aspectranNodeParser;
    private EntityResolver entityResolver;

    public HybridRuleAppendHandler(ActivityRuleAssistant assistant, String encoding) {
        super(assistant);
        this.encoding = encoding;
    }

    @Override
    public void handle(RuleAppender appender) throws Exception {
        this.setCurrentRuleAppender(appender);
        AssistantLocal assistantLocal = this.getContextRuleAssistant().backupAssistantLocal();
        if (appender != null) {
            if (appender.getAppenderType() == AppenderType.PARAMETERS) {
                AspectranParameters aspectranParameters = appender.getAppendRule().getAspectranParameters();
                RootParameters rootParameters = new RootParameters(aspectranParameters);
                this.convertAsRules(rootParameters);
            } else {
                if (appender.getAppendableFileFormatType() == AppendableFileFormatType.APON) {
                    try (Reader reader = appender.getReader(this.encoding);){
                        RootParameters rootParameters = new RootParameters(reader);
                        this.convertAsRules(rootParameters);
                    }
                }
                if (this.isUseAponToLoadXml()) {
                    RootParameters rootParameters;
                    if (appender.getAppenderType() == AppenderType.FILE) {
                        FileRuleAppender fileRuleAppender = (FileRuleAppender)appender;
                        rootParameters = (RootParameters)((Object)XmlToApon.from(fileRuleAppender.getFile(), RootParameters.class, this.getEntityResolver()));
                        if (this.isDebugMode()) {
                            this.saveAsAponFile(fileRuleAppender, rootParameters);
                        }
                    } else {
                        try (Reader reader = appender.getReader(this.encoding);){
                            rootParameters = (RootParameters)((Object)XmlToApon.from(reader, RootParameters.class, this.getEntityResolver()));
                        }
                    }
                    this.convertAsRules(rootParameters);
                } else {
                    this.getAspectranNodeParser().parse(appender);
                    if (this.isDebugMode() && appender.getAppenderType() == AppenderType.FILE) {
                        FileRuleAppender fileRuleAppender = (FileRuleAppender)appender;
                        this.saveAsAponFile(fileRuleAppender);
                    }
                }
            }
        }
        super.handle();
        if (assistantLocal.getReplicatedCount() > 0) {
            this.getContextRuleAssistant().restoreAssistantLocal(assistantLocal);
        }
    }

    private AspectranNodeParser getAspectranNodeParser() {
        if (this.aspectranNodeParser == null) {
            this.aspectranNodeParser = new AspectranNodeParser(this.getContextRuleAssistant());
        }
        return this.aspectranNodeParser;
    }

    private EntityResolver getEntityResolver() {
        if (this.entityResolver == null) {
            this.entityResolver = new AspectranDtdResolver(false);
        }
        return this.entityResolver;
    }

    private void convertAsRules(RootParameters rootParameters) throws IllegalRuleException {
        new ParametersToRules(this.getContextRuleAssistant()).toRules(rootParameters);
    }

    private void saveAsAponFile(FileRuleAppender fileRuleAppender) throws IOException {
        RootParameters rootParameters;
        ShallowContextRuleAssistant assistant = null;
        try {
            assistant = new ShallowContextRuleAssistant();
            ((ActivityRuleAssistant)assistant).ready();
            AspectranNodeParser parser = new AspectranNodeParser(assistant, false, false);
            parser.parse(fileRuleAppender);
            rootParameters = RulesToParameters.toRootParameters(assistant);
        }
        catch (Exception e) {
            throw new IOException("Failed to convert as Root Parameters: " + fileRuleAppender, e);
        }
        finally {
            if (assistant != null) {
                ((ActivityRuleAssistant)assistant).release();
            }
        }
        this.saveAsAponFile(fileRuleAppender, rootParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAsAponFile(FileRuleAppender fileRuleAppender, RootParameters rootParameters) throws IOException {
        File xmlFile = this.makeFile(fileRuleAppender);
        File aponFile = this.makeAponFile(fileRuleAppender);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Save as APON file: " + aponFile);
        }
        try {
            Object aponWriter;
            if (this.encoding != null) {
                FileOutputStream outputStream = new FileOutputStream(aponFile);
                aponWriter = new AponWriter(new OutputStreamWriter((OutputStream)outputStream, this.encoding)).nullWritable(false);
            } else {
                aponWriter = new AponWriter(new FileWriter(aponFile)).nullWritable(false);
            }
            try {
                ((AponWriter)aponWriter).comment(xmlFile.getAbsolutePath());
                ((AponWriter)aponWriter).write(rootParameters);
            }
            finally {
                try {
                    ((AponWriter)aponWriter).close();
                }
                catch (IOException e) {
                    this.logger.error("Exception during closing file " + aponFile, e);
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to save as APON file: " + aponFile, e);
        }
    }

    private File makeFile(FileRuleAppender fileRuleAppender) {
        String basePath = fileRuleAppender.getBasePath();
        String filePath = fileRuleAppender.getFilePath();
        return new File(basePath, filePath);
    }

    private File makeAponFile(FileRuleAppender fileRuleAppender) {
        String basePath = fileRuleAppender.getBasePath();
        String filePath = fileRuleAppender.getFilePath() + "." + AppendableFileFormatType.APON.toString();
        return new File(basePath, filePath);
    }
}

