/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser.xml;

import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.DescriptionRule;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.parser.xml.AspectranNodeParser;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.nodelet.NodeletAdder;
import com.aspectran.core.util.nodelet.NodeletParser;

class InnerBeanNodeletAdder
implements NodeletAdder {
    private final int depth;

    InnerBeanNodeletAdder(int depth) {
        this.depth = depth;
    }

    @Override
    public void add(String xpath, NodeletParser parser) {
        AspectranNodeParser nodeParser = (AspectranNodeParser)parser.getNodeParser();
        ActivityRuleAssistant assistant = nodeParser.getAssistant();
        parser.setXpath(xpath + "/bean");
        parser.addNodelet(attrs -> {
            String className = StringUtils.emptyToNull(assistant.resolveAliasType((String)attrs.get("class")));
            String factoryBean = StringUtils.emptyToNull((String)attrs.get("factoryBean"));
            String factoryMethod = StringUtils.emptyToNull((String)attrs.get("factoryMethod"));
            String initMethod = StringUtils.emptyToNull((String)attrs.get("initMethod"));
            String destroyMethod = StringUtils.emptyToNull((String)attrs.get("destroyMethod"));
            BeanRule beanRule = className == null && factoryBean != null ? BeanRule.newInnerOfferedFactoryBeanRule(factoryBean, factoryMethod, initMethod, destroyMethod) : BeanRule.newInnerBeanRule(className, initMethod, destroyMethod, factoryMethod);
            parser.pushObject(beanRule);
        });
        parser.addNodeEndlet(text -> {
            BeanRule beanRule = (BeanRule)parser.popObject();
            assistant.resolveBeanClass(beanRule);
            assistant.resolveFactoryBeanClass(beanRule);
            assistant.addInnerBeanRule(beanRule);
            ItemRule itemRule = (ItemRule)parser.peekObject();
            if (itemRule.isListableType()) {
                itemRule.addBeanRule(beanRule);
            } else if (itemRule.isMappableType()) {
                String name = (String)parser.peekObject();
                itemRule.putBeanRule(name, beanRule);
            } else {
                itemRule.setBeanRule(beanRule);
            }
        });
        parser.setXpath(xpath + "/bean/description");
        parser.addNodelet(attrs -> {
            String profile = (String)attrs.get("profile");
            String style = (String)attrs.get("style");
            DescriptionRule descriptionRule = DescriptionRule.newInstance(profile, style);
            parser.pushObject(descriptionRule);
        });
        parser.addNodeEndlet(text -> {
            DescriptionRule descriptionRule = (DescriptionRule)parser.popObject();
            BeanRule beanRule = (BeanRule)parser.peekObject();
            descriptionRule.setContent(text);
            descriptionRule = assistant.profiling(descriptionRule, beanRule.getDescriptionRule());
            beanRule.setDescriptionRule(descriptionRule);
        });
        parser.setXpath(xpath + "/bean/arguments");
        parser.addNodelet(attrs -> {
            ItemRuleMap irm = new ItemRuleMap();
            irm.setProfile(StringUtils.emptyToNull((String)attrs.get("profile")));
            parser.pushObject(irm);
        });
        nodeParser.addItemNodelets(this.depth);
        parser.addNodeEndlet(text -> {
            ItemRuleMap irm = (ItemRuleMap)parser.popObject();
            BeanRule beanRule = (BeanRule)parser.peekObject();
            irm = assistant.profiling(irm, beanRule.getConstructorArgumentItemRuleMap());
            beanRule.setConstructorArgumentItemRuleMap(irm);
        });
        parser.setXpath(xpath + "/bean/properties");
        parser.addNodelet(attrs -> {
            ItemRuleMap irm = new ItemRuleMap();
            irm.setProfile(StringUtils.emptyToNull((String)attrs.get("profile")));
            parser.pushObject(irm);
        });
        nodeParser.addItemNodelets(this.depth);
        parser.addNodeEndlet(text -> {
            ItemRuleMap irm = (ItemRuleMap)parser.popObject();
            BeanRule beanRule = (BeanRule)parser.peekObject();
            irm = assistant.profiling(irm, beanRule.getPropertyItemRuleMap());
            beanRule.setPropertyItemRuleMap(irm);
        });
    }
}

