/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.service;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.InsufficientEnvironmentException;
import com.aspectran.core.context.builder.ActivityContextBuilder;
import com.aspectran.core.context.builder.ActivityContextBuilderException;
import com.aspectran.core.context.builder.HybridActivityContextBuilder;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ContextConfig;
import com.aspectran.core.context.config.ExposalsConfig;
import com.aspectran.core.context.config.SchedulerConfig;
import com.aspectran.core.context.config.SystemConfig;
import com.aspectran.core.context.resource.AspectranClassLoader;
import com.aspectran.core.scheduler.service.QuartzSchedulerService;
import com.aspectran.core.scheduler.service.SchedulerService;
import com.aspectran.core.service.AbstractServiceController;
import com.aspectran.core.service.AspectranServiceException;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.service.ServiceController;
import com.aspectran.core.util.Assert;
import com.aspectran.core.util.FileLocker;
import com.aspectran.core.util.ShutdownHook;
import com.aspectran.core.util.SystemUtils;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.core.util.wildcard.PluralWildcardPattern;
import java.io.File;
import java.io.IOException;

public abstract class AbstractCoreService
extends AbstractServiceController
implements CoreService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CoreService rootService;
    private final boolean lateStart;
    private String basePath;
    private AspectranConfig aspectranConfig;
    private PluralWildcardPattern exposableTransletNamesPattern;
    private ActivityContextBuilder activityContextBuilder;
    private ActivityContext activityContext;
    private SchedulerService schedulerService;
    private FileLocker fileLocker;

    public AbstractCoreService() {
        this(null);
    }

    public AbstractCoreService(CoreService rootService) {
        super(true);
        if (rootService != null) {
            Assert.state(rootService.getActivityContext() != null, "Oops! No ActivityContext configured");
            this.rootService = rootService;
            this.activityContext = rootService.getActivityContext();
            this.aspectranConfig = rootService.getAspectranConfig();
            this.lateStart = rootService.getServiceController().isActive();
            this.setBasePath(rootService.getBasePath());
            rootService.joinDerivedService(this);
        } else {
            this.rootService = null;
            this.lateStart = false;
        }
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    protected void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public boolean isLateStart() {
        return this.lateStart;
    }

    @Override
    public boolean isHardReload() {
        Assert.state(this.activityContextBuilder != null, "No ActivityContextLoader configured; First, call the prepare() method");
        return this.activityContextBuilder.isHardReload();
    }

    @Override
    public ServiceController getServiceController() {
        return this;
    }

    @Override
    public void joinDerivedService(CoreService coreService) {
        super.joinDerivedService(coreService.getServiceController());
    }

    @Override
    public void withdrawDerivedService(CoreService coreService) {
        Assert.state(coreService.isDerived(), "Not derived service: " + coreService);
        Assert.state(!coreService.getServiceController().isActive(), "Not stopped service: " + coreService);
        super.withdrawDerivedService(coreService.getServiceController());
    }

    @Override
    public void leaveFromRootService() {
        Assert.state(this.isDerived(), "Not derived service: " + this);
        Assert.state(!this.isActive(), "Not stopped service: " + this);
        this.rootService.withdrawDerivedService(this);
    }

    @Override
    public boolean isDerived() {
        return this.rootService != null;
    }

    protected boolean isExposable(String transletName) {
        return this.exposableTransletNamesPattern == null || this.exposableTransletNamesPattern.matches(transletName);
    }

    protected void setExposals(String[] includePatterns, String[] excludePatterns) {
        if (includePatterns != null && includePatterns.length > 0 || excludePatterns != null && excludePatterns.length > 0) {
            this.exposableTransletNamesPattern = new PluralWildcardPattern(includePatterns, excludePatterns, '/');
        }
    }

    protected void prepare(AspectranConfig aspectranConfig) throws AspectranServiceException {
        Assert.state(this.activityContext == null, "ActivityContext is already configured");
        try {
            ContextConfig contextConfig;
            this.aspectranConfig = aspectranConfig;
            SystemConfig systemConfig = aspectranConfig.getSystemConfig();
            if (systemConfig != null) {
                for (String key : systemConfig.getPropertyKeys()) {
                    String value = systemConfig.getProperty(key);
                    if (value == null) continue;
                    System.setProperty(key, value);
                }
            }
            if ((contextConfig = aspectranConfig.getContextConfig()) != null) {
                boolean singleton;
                String basePath = contextConfig.getBasePath();
                if (basePath != null) {
                    this.setBasePath(basePath);
                }
                if ((singleton = contextConfig.isSingleton()) && !this.checkSingletonLock()) {
                    throw new InsufficientEnvironmentException("Another instance of Aspectran is already running; Only one instance is allowed (context.singleton is set to true)");
                }
            }
            this.activityContextBuilder = new HybridActivityContextBuilder(this);
            this.activityContextBuilder.setBasePath(this.getBasePath());
            this.activityContextBuilder.setContextConfig(contextConfig);
            this.activityContextBuilder.setServiceController(this);
            this.schedulerService = this.createSchedulerService(aspectranConfig.getSchedulerConfig());
        }
        catch (Exception e) {
            throw new AspectranServiceException("Unable to prepare the service", e);
        }
    }

    protected void loadActivityContext() throws ActivityContextBuilderException {
        Assert.state(this.activityContextBuilder != null, "No ActivityContextLoader configured; First, call the prepare() method");
        Assert.state(this.activityContext == null, "ActivityContext is already configured; Must destroy the current ActivityContext before reloading");
        this.activityContextBuilder.build();
    }

    protected void destroyActivityContext() {
        Assert.state(this.activityContextBuilder != null, "No ActivityContextLoader configured; First, call the prepare() method");
        this.activityContextBuilder.destroy();
    }

    @Override
    public ActivityContext getActivityContext() {
        return this.activityContext;
    }

    public void setActivityContext(ActivityContext activityContext) {
        this.activityContext = activityContext;
    }

    @Override
    public Activity getDefaultActivity() {
        Assert.state(this.getActivityContext() != null, "No ActivityContext configured yet");
        return this.getActivityContext().getDefaultActivity();
    }

    @Override
    public AspectranClassLoader getAspectranClassLoader() {
        Assert.state(this.activityContextBuilder != null, "No ActivityContextLoader configured; First, call the prepare() method");
        return this.activityContextBuilder.getAspectranClassLoader();
    }

    @Override
    public AspectranConfig getAspectranConfig() {
        return this.aspectranConfig;
    }

    @Override
    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    private SchedulerService createSchedulerService(SchedulerConfig schedulerConfig) {
        if (schedulerConfig == null) {
            return null;
        }
        if (!schedulerConfig.isEnabled()) {
            return null;
        }
        int startDelaySeconds = schedulerConfig.getStartDelaySeconds();
        boolean waitOnShutdown = schedulerConfig.isWaitOnShutdown();
        ExposalsConfig exposalsConfig = schedulerConfig.getExposalsConfig();
        if (startDelaySeconds == -1) {
            startDelaySeconds = 5;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Scheduler option 'startDelaySeconds' is not specified, defaulting to 5 seconds");
            }
        }
        QuartzSchedulerService schedulerService = new QuartzSchedulerService(this);
        if (waitOnShutdown) {
            schedulerService.setWaitOnShutdown(true);
        }
        schedulerService.setStartDelaySeconds(startDelaySeconds);
        if (exposalsConfig != null) {
            String[] includePatterns = exposalsConfig.getIncludePatterns();
            String[] excludePatterns = exposalsConfig.getExcludePatterns();
            schedulerService.setExposals(includePatterns, excludePatterns);
        }
        return schedulerService;
    }

    private boolean checkSingletonLock() throws Exception {
        Assert.state(this.fileLocker == null, "Singleton lock is already configured");
        try {
            String basePath = this.getBasePath();
            if (basePath == null) {
                basePath = SystemUtils.getJavaIoTmpDir();
            }
            Assert.state(basePath != null, "Unable to determine the directory where the lock file will be located");
            this.fileLocker = new FileLocker(new File(basePath, ".lock"));
            if (this.fileLocker.lock()) {
                ShutdownHook.addTask(() -> {
                    if (this.fileLocker != null) {
                        try {
                            this.fileLocker.release();
                            this.fileLocker = null;
                        }
                        catch (Exception e) {
                            this.logger.warn("Unable to release singleton lock: " + e);
                        }
                    }
                });
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new Exception("Unable to acquire singleton lock", e);
        }
    }

    protected void determineBasePath() {
        try {
            String baseDir = SystemUtils.getProperty("aspectran.basePath");
            if (baseDir != null) {
                File dir = new File(baseDir);
                if (!dir.isDirectory()) {
                    throw new IOException("Make sure it is a valid base directory; aspectran.basePath=" + baseDir);
                }
            } else {
                baseDir = new File("").getCanonicalPath();
            }
            this.setBasePath(baseDir);
        }
        catch (IOException e) {
            throw new AspectranServiceException("Can not verify base directory");
        }
    }
}

