/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.service;

import com.aspectran.core.service.AbstractCoreService;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.util.ShutdownHook;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;

public class AspectranCoreService
extends AbstractCoreService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ShutdownHook.Task shutdownTask;

    public AspectranCoreService() {
    }

    public AspectranCoreService(CoreService rootService) {
        super(rootService);
    }

    protected void afterContextLoaded() throws Exception {
    }

    protected void beforeContextDestroy() {
    }

    @Override
    protected void doStart() throws Exception {
        this.startAspectranService();
        if (this.getSchedulerService() != null) {
            this.joinDerivedService(this.getSchedulerService());
        }
        if (!this.isDerived()) {
            this.registerShutdownTask();
        }
    }

    @Override
    protected void doPause() throws Exception {
    }

    @Override
    protected void doPause(long timeout) throws Exception {
    }

    @Override
    protected void doResume() throws Exception {
    }

    @Override
    protected void doStop() {
        this.clearDerivedService();
        this.stopAspectranService();
        this.removeShutdownTask();
    }

    private void startAspectranService() throws Exception {
        this.loadActivityContext();
        this.afterContextLoaded();
    }

    private void stopAspectranService() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Destroying all cached resources...");
        }
        this.beforeContextDestroy();
        this.destroyActivityContext();
    }

    private void registerShutdownTask() {
        if (this.shutdownTask == null) {
            this.shutdownTask = ShutdownHook.addTask(() -> {
                if (this.isActive()) {
                    this.stop();
                }
            });
        }
    }

    private void removeShutdownTask() {
        if (this.shutdownTask != null) {
            ShutdownHook.removeTask(this.shutdownTask);
            this.shutdownTask = null;
        }
    }
}

