/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.support.i18n.locale;

import com.aspectran.core.activity.Translet;
import com.aspectran.core.lang.Nullable;
import com.aspectran.core.support.i18n.locale.LocaleResolver;
import com.aspectran.core.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public abstract class AbstractLocaleResolver
implements LocaleResolver {
    private List<Locale> supportedLocales;
    private Locale defaultLocale;
    private TimeZone defaultTimeZone;

    public List<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    public void setSupportedLocales(List<Locale> locales) {
        this.supportedLocales = locales;
    }

    public void setSupportedLocales(String[] locales) {
        if (locales == null || locales.length == 0) {
            this.supportedLocales = null;
            return;
        }
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>(locales.length);
        for (String locale : locales) {
            supportedLocales.add(StringUtils.parseLocale(locale));
        }
        this.supportedLocales = !supportedLocales.isEmpty() ? supportedLocales : null;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public void setDefaultLocale(String defaultLocale) {
        this.setDefaultLocale(StringUtils.parseLocale(defaultLocale));
    }

    @Nullable
    public TimeZone getDefaultTimeZone() {
        return this.defaultTimeZone;
    }

    public void setDefaultTimeZone(TimeZone defaultTimeZone) {
        this.defaultTimeZone = defaultTimeZone;
    }

    public void setDefaultTimeZone(String defaultTimeZone) {
        this.setDefaultTimeZone(StringUtils.parseTimeZoneString(defaultTimeZone));
    }

    protected Locale determineDefaultLocale(Translet translet) {
        Locale locale = translet.getRequestAdapter().getLocale();
        if (locale != null && !this.isSupportedLocale(locale)) {
            locale = null;
        }
        if (locale == null && (locale = this.getDefaultLocale()) != null) {
            translet.getRequestAdapter().setLocale(locale);
        }
        return locale;
    }

    protected TimeZone determineDefaultTimeZone(Translet translet) {
        TimeZone timeZone = translet.getRequestAdapter().getTimeZone();
        if (timeZone == null && (timeZone = this.getDefaultTimeZone()) != null) {
            translet.getRequestAdapter().setTimeZone(timeZone);
        }
        return timeZone;
    }

    private boolean isSupportedLocale(Locale locale) {
        if (this.supportedLocales == null) {
            return true;
        }
        for (Locale loc : this.supportedLocales) {
            if (!(!loc.getCountry().isEmpty() || !loc.getVariant().isEmpty() || loc.hasExtensions() ? loc.equals(locale) : loc.getLanguage().equals(locale.getLanguage()))) continue;
            return true;
        }
        return false;
    }
}

