/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.util.ResourceUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.core.util.wildcard.WildcardMatcher;
import com.aspectran.core.util.wildcard.WildcardPattern;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassScanner {
    private static final Logger logger = LoggerFactory.getLogger(ClassScanner.class);
    private final ClassLoader classLoader;

    public ClassScanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Map<String, Class<?>> scan(String classNamePattern) throws IOException {
        LinkedHashMap scannedClasses = new LinkedHashMap();
        this.scan(classNamePattern, scannedClasses);
        return scannedClasses;
    }

    public void scan(String classNamePattern, Map<String, Class<?>> scannedClasses) throws IOException {
        this.scan(classNamePattern, scannedClasses::put);
    }

    public void scan(String classNamePattern, SaveHandler saveHandler) throws IOException {
        if (classNamePattern == null) {
            throw new IllegalArgumentException("classNamePattern must not be null");
        }
        Object basePackageName = this.determineBasePackageName(classNamePattern = classNamePattern.replace('.', '/'));
        if (basePackageName == null) {
            return;
        }
        String subPattern = classNamePattern.length() > ((String)basePackageName).length() ? classNamePattern.substring(((String)basePackageName).length()) : "";
        WildcardPattern pattern = WildcardPattern.compile(subPattern, '/');
        WildcardMatcher matcher = new WildcardMatcher(pattern);
        Enumeration<URL> resources = this.classLoader.getResources((String)basePackageName);
        if (!StringUtils.endsWith((String)basePackageName, '/')) {
            basePackageName = (String)basePackageName + "/";
        }
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            if (logger.isDebugEnabled()) {
                logger.debug("Scanning components in path: " + resource.getFile());
            }
            if (this.isJarResource(resource)) {
                this.scanFromJarResource(resource, matcher, saveHandler);
                continue;
            }
            this.scan(resource.getFile(), (String)basePackageName, null, matcher, saveHandler);
        }
    }

    private void scan(String targetPath, String basePackageName, String relativePackageName, WildcardMatcher matcher, SaveHandler saveHandler) {
        File target = new File(targetPath);
        if (!target.exists()) {
            return;
        }
        target.listFiles(file -> {
            String fileName = file.getName();
            if (file.isDirectory()) {
                String subPackageName = relativePackageName != null ? relativePackageName + fileName + "/" : fileName + "/";
                String basePath2 = targetPath + fileName + "/";
                this.scan(basePath2, basePackageName, subPackageName, matcher, saveHandler);
            } else if (fileName.endsWith(".class")) {
                String fn = fileName.substring(0, fileName.length() - ".class".length());
                String className = relativePackageName != null ? basePackageName + relativePackageName + fn : basePackageName + fn;
                String relativePath = className.substring(basePackageName.length());
                if (matcher.matches(relativePath)) {
                    String resourceName = targetPath + fileName;
                    Class<?> targetClass = this.loadClass(className);
                    saveHandler.save(resourceName, targetClass);
                }
            }
            return false;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanFromJarResource(URL resource, WildcardMatcher matcher, SaveHandler saveHandler) throws IOException {
        Object entryNamePrefix;
        String jarFileUrl;
        JarFile jarFile;
        URLConnection conn = resource.openConnection();
        boolean newJarFile = false;
        if (conn instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)conn;
            jarCon.setUseCaches(false);
            jarFile = jarCon.getJarFile();
            jarFileUrl = jarCon.getJarFileURL().toExternalForm();
            JarEntry jarEntry = jarCon.getJarEntry();
            entryNamePrefix = jarEntry != null ? jarEntry.getName() : "";
        } else {
            String urlFile = resource.getFile();
            int separatorIndex = urlFile.indexOf("!/");
            if (separatorIndex != -1) {
                jarFileUrl = urlFile.substring(0, separatorIndex);
                entryNamePrefix = urlFile.substring(separatorIndex + "!/".length());
                jarFile = this.getJarFile(jarFileUrl);
            } else {
                jarFile = new JarFile(urlFile);
                jarFileUrl = urlFile;
                entryNamePrefix = "";
            }
            newJarFile = true;
        }
        try {
            if (!((String)entryNamePrefix).endsWith("/")) {
                entryNamePrefix = (String)entryNamePrefix + "/";
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String entryNameSuffix;
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.startsWith((String)entryNamePrefix) || !entryName.endsWith(".class") || !matcher.matches(entryNameSuffix = entryName.substring(((String)entryNamePrefix).length(), entryName.length() - ".class".length()))) continue;
                String resourceName = jarFileUrl + "!/" + entryName;
                String className = (String)entryNamePrefix + entryNameSuffix;
                Class<?> targetClass = this.loadClass(className);
                saveHandler.save(resourceName, targetClass);
            }
        }
        finally {
            if (newJarFile) {
                jarFile.close();
            }
        }
    }

    private JarFile getJarFile(String jarFileUrl) throws IOException {
        if (jarFileUrl.startsWith("file:")) {
            try {
                return new JarFile(ResourceUtils.toURI(jarFileUrl).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new JarFile(jarFileUrl.substring("file:".length()));
            }
        }
        return new JarFile(jarFileUrl);
    }

    private boolean isJarResource(URL url) {
        String protocol = url.getProtocol();
        return "jar".equals(protocol) || "zip".equals(protocol);
    }

    private String determineBasePackageName(String classNamePattern) {
        String str;
        WildcardPattern pattern = new WildcardPattern(classNamePattern, '/');
        WildcardMatcher matcher = new WildcardMatcher(pattern);
        boolean matched = matcher.matches(classNamePattern);
        if (!matched) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (matcher.hasNext() && !WildcardPattern.hasWildcards(str = matcher.next())) {
            sb.append(str).append('/');
        }
        return sb.toString();
    }

    private Class<?> loadClass(String className) {
        className = className.replace('/', '.');
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load class: " + className, e);
        }
    }

    public static interface SaveHandler {
        public void save(String var1, Class<?> var2);
    }
}

