/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.util.ClassUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class CustomObjectInputStream
extends ObjectInputStream {
    private final ClassLoader classLoader;

    public CustomObjectInputStream(InputStream in) throws IOException {
        this(in, ClassUtils.getDefaultClassLoader());
    }

    public CustomObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
        super(in);
        this.classLoader = classLoader;
    }

    @Override
    public Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        try {
            return Class.forName(classDesc.getName(), false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            return super.resolveClass(classDesc);
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws ClassNotFoundException {
        Class[] resolvedInterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            resolvedInterfaces[i] = Class.forName(interfaces[i], false, this.classLoader);
        }
        try {
            Class<?> proxyClass = Proxy.getProxyClass(this.classLoader, resolvedInterfaces);
            return proxyClass;
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

