/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.context.InsufficientEnvironmentException;
import com.aspectran.core.lang.Nullable;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.SystemUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jasypt.encryption.ByteEncryptor;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEByteEncryptor;

public class PBEncryptionUtils {
    public static final String DEFAULT_ALGORITHM = "PBEWithMD5AndTripleDES";
    public static final String ENCRYPTION_ALGORITHM_KEY = "aspectran.encryption.algorithm";
    public static final String ENCRYPTION_PASSWORD_KEY = "aspectran.encryption.password";
    private static final Charset MESSAGE_CHARSET = StandardCharsets.UTF_8;
    private static final Charset ENCRYPTED_MESSAGE_CHARSET = StandardCharsets.US_ASCII;
    private static final String algorithm = StringUtils.trimWhitespace(SystemUtils.getProperty("aspectran.encryption.algorithm", "PBEWithMD5AndTripleDES"));
    private static final String password = StringUtils.trimWhitespace(SystemUtils.getProperty("aspectran.encryption.password"));
    private static final StringEncryptor encryptor = StringUtils.hasText(password) ? PBEncryptionUtils.getStringEncryptor(password) : null;

    public static String getAlgorithm() {
        return algorithm;
    }

    public static String getPassword() {
        return password;
    }

    public static String encrypt(String inputString) {
        return encryptor.encrypt(inputString);
    }

    public static String decrypt(String encryptedString) {
        return encryptor.decrypt(encryptedString);
    }

    public static String encrypt(String inputString, String encryptionPassword) {
        ByteEncryptor byteEncryptor = PBEncryptionUtils.getByteEncryptor(encryptionPassword);
        CustomStringEncryptor stringEncryptor = new CustomStringEncryptor(byteEncryptor);
        return stringEncryptor.encrypt(inputString);
    }

    public static String decrypt(String encryptedString, String encryptionPassword) {
        ByteEncryptor byteEncryptor = PBEncryptionUtils.getByteEncryptor(encryptionPassword);
        CustomStringEncryptor stringEncryptor = new CustomStringEncryptor(byteEncryptor);
        return stringEncryptor.decrypt(encryptedString);
    }

    public static StringEncryptor getDefaultEncryptor() {
        if (encryptor == null) {
            PBEncryptionUtils.checkPassword(null);
        }
        return encryptor;
    }

    public static StringEncryptor getStringEncryptor(String encryptionPassword) {
        return new CustomStringEncryptor(PBEncryptionUtils.getByteEncryptor(encryptionPassword));
    }

    public static ByteEncryptor getByteEncryptor(String encryptionPassword) {
        PBEncryptionUtils.checkPassword(encryptionPassword);
        StandardPBEByteEncryptor byteEncryptor = new StandardPBEByteEncryptor();
        byteEncryptor.setAlgorithm(algorithm);
        byteEncryptor.setPassword(encryptionPassword);
        return byteEncryptor;
    }

    private static void checkPassword(@Nullable String encryptionPassword) {
        if (!StringUtils.hasText(encryptionPassword)) {
            throw new InsufficientEnvironmentException("A password is required to attempt password-based encryption or decryption; Make sure the JVM system property \"aspectran.encryption.password\" is set up; (Default algorithm: " + PBEncryptionUtils.getAlgorithm() + ")");
        }
    }

    private static final class CustomStringEncryptor
    implements StringEncryptor {
        private final ByteEncryptor byteEncryptor;

        public CustomStringEncryptor(ByteEncryptor byteEncryptor) {
            this.byteEncryptor = byteEncryptor;
        }

        public String encrypt(String inputString) {
            if (inputString == null) {
                throw new IllegalArgumentException("inputString must not be null");
            }
            byte[] bytes = inputString.getBytes(MESSAGE_CHARSET);
            byte[] encrypted = this.encode(this.byteEncryptor.encrypt(bytes));
            return new String(encrypted, ENCRYPTED_MESSAGE_CHARSET);
        }

        public String decrypt(String encryptedString) {
            if (encryptedString == null) {
                throw new IllegalArgumentException("encryptedString must not be null");
            }
            byte[] encrypted = this.decode(encryptedString.getBytes(ENCRYPTED_MESSAGE_CHARSET));
            byte[] decrypted = this.byteEncryptor.decrypt(encrypted);
            return new String(decrypted, MESSAGE_CHARSET);
        }

        private byte[] encode(byte[] inputBytes) {
            return Base64.getUrlEncoder().withoutPadding().encode(inputBytes);
        }

        private byte[] decode(byte[] inputBytes) {
            return Base64.getUrlDecoder().decode(inputBytes);
        }
    }
}

