/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.context.rule.type.TextStyleType;
import com.aspectran.core.util.apon.AponFormat;

public class TextStyler {
    public static String styling(String text, String style) {
        TextStyleType textStyleType = TextStyleType.resolve(style);
        if (style != null && textStyleType == null) {
            throw new IllegalArgumentException("No text style type for '" + style + "'");
        }
        return TextStyler.styling(text, textStyleType);
    }

    public static String styling(String text, TextStyleType textStyleType) {
        if (textStyleType == TextStyleType.APON) {
            return TextStyler.stripAponStyle(text);
        }
        if (textStyleType == TextStyleType.COMPACT) {
            return TextStyler.compact(text);
        }
        if (textStyleType == TextStyleType.COMPRESSED) {
            return TextStyler.compress(text);
        }
        return text;
    }

    public static String stripAponStyle(String text) {
        int end;
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text.length());
        int start = 0;
        int line = 0;
        for (end = 0; end < text.length(); ++end) {
            char c = text.charAt(end);
            if (start == 0 && c == '|') {
                if (line > 0) {
                    sb.append(AponFormat.SYSTEM_NEW_LINE);
                }
                start = end + 1;
                ++line;
                continue;
            }
            if (start <= 0 || c != '\n' && c != '\r') continue;
            if (end > start) {
                sb.append(text, start, end);
            }
            start = 0;
        }
        if (start > 0 && start < text.length()) {
            sb.append(text, start, text.length());
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        for (start = 0; start < text.length() && text.charAt(start) == ' '; ++start) {
        }
        for (end = text.length(); end > 0 && text.charAt(end - 1) == ' '; --end) {
        }
        return text.substring(start, end);
    }

    public static String compact(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        text = text.trim();
        StringBuilder sb = new StringBuilder(text.length());
        int start = 0;
        for (int end = 0; end < text.length(); ++end) {
            char c = text.charAt(end);
            if (c == '\n' || c == '\r') {
                if (start <= -1) continue;
                sb.append(text.substring(start, end).trim());
                sb.append(System.lineSeparator());
                start = -1;
                continue;
            }
            if (start != -1) continue;
            start = end;
        }
        if (start > -1) {
            sb.append(text.substring(start).trim());
        }
        return sb.toString();
    }

    public static String compress(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        text = text.trim();
        StringBuilder sb = new StringBuilder(text.length());
        int start = 0;
        for (int end = 0; end < text.length(); ++end) {
            char c = text.charAt(end);
            if (c == '\n' || c == '\r') {
                if (start <= -1) continue;
                sb.append(text.substring(start, end).trim());
                start = -1;
                continue;
            }
            if (start != -1) continue;
            start = end;
        }
        if (start > -1) {
            sb.append(text.substring(start).trim());
        }
        return sb.toString();
    }
}

