/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.apon;

import com.aspectran.core.util.ClassUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.apon.AponFormat;
import com.aspectran.core.util.apon.AponParseException;
import com.aspectran.core.util.apon.ArrayParameters;
import com.aspectran.core.util.apon.MalformedAponException;
import com.aspectran.core.util.apon.MissingClosingBracketException;
import com.aspectran.core.util.apon.ParameterValue;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.apon.ValueType;
import com.aspectran.core.util.apon.VariableParameters;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

public class AponReader
extends AponFormat
implements Closeable {
    private final BufferedReader reader;
    private int lineNumber;

    public AponReader(String text) {
        this(new StringReader(text));
    }

    public AponReader(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public Parameters read() throws IOException {
        VariableParameters parameters = new VariableParameters();
        return this.read(parameters);
    }

    public <T extends Parameters> T read(T parameters) throws IOException {
        if (parameters == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        try {
            if (parameters instanceof ArrayParameters) {
                this.readArray(parameters);
            } else {
                this.read(parameters, '\u0000', null, null, null, false);
            }
        }
        catch (AponParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AponParseException("Failed to read APON document with specified parameters object " + parameters.getClass().getName(), e);
        }
        return parameters;
    }

    private void readArray(Parameters container) throws IOException {
        String line;
        while ((line = this.reader.readLine()) != null) {
            char cchar;
            ++this.lineNumber;
            String tline = line.trim();
            int tlen = tline.length();
            if (tlen == 0 || tline.charAt(0) == '#') continue;
            String value = tline;
            int vlen = value.length();
            char c = cchar = vlen == 1 ? value.charAt(0) : (char)'\u0000';
            if (cchar != '{') {
                throw this.syntaxError(line, tline, "Expected to open curly brackets, but encounter string: " + value);
            }
            Object ps = container.newParameters("<noname>");
            this.read((Parameters)ps, '{', null, null, null, false);
        }
    }

    private void read(Parameters container, char openedBracket, String name, ParameterValue parameterValue, ValueType valueType, boolean valueTypeHinted) throws IOException {
        String line;
        while ((line = this.reader.readLine()) != null) {
            char cchar;
            int vlen;
            String value;
            ++this.lineNumber;
            String tline = line.trim();
            int tlen = tline.length();
            if (tlen == 0 || tline.charAt(0) == '#' && openedBracket != '[') continue;
            if (openedBracket == '[') {
                value = tline;
                vlen = value.length();
                char c = cchar = vlen == 1 ? value.charAt(0) : (char)'\u0000';
                if (']' == cchar) {
                    return;
                }
            } else {
                int index;
                if (tlen == 1) {
                    cchar = tline.charAt(0);
                    if (openedBracket == '{' && '}' == cchar) {
                        return;
                    }
                    if ('{' == cchar) {
                        if (!container.hasParameter("<noname>")) {
                            container.newParameterValue("<noname>", ValueType.PARAMETERS, true);
                        }
                        Object ps = container.newParameters("<noname>");
                        this.read((Parameters)ps, '{', null, null, null, false);
                        continue;
                    }
                }
                if ((index = tline.indexOf(58)) == -1) {
                    throw this.syntaxError(line, tline, "Failed to break up string of name/value pairs");
                }
                if (index == 0) {
                    throw this.syntaxError(line, tline, "Unrecognized parameter name");
                }
                name = tline.substring(0, index).trim();
                value = tline.substring(index + 1).trim();
                vlen = value.length();
                cchar = vlen == 1 ? value.charAt(0) : (char)'\u0000';
                parameterValue = container.getParameterValueMap().get(name);
                if (parameterValue != null) {
                    valueType = parameterValue.getValueType();
                } else {
                    if (container.isStructureFixed()) {
                        throw this.syntaxError(line, tline, "Parameter '" + name + "' is not defined; " + container);
                    }
                    valueType = ValueType.resolveByHint(name);
                    if (valueType != null) {
                        valueTypeHinted = true;
                        name = ValueType.stripValueTypeHint(name);
                        parameterValue = container.getParameterValueMap().get(name);
                        if (parameterValue != null) {
                            valueType = parameterValue.getValueType();
                        }
                    } else {
                        valueTypeHinted = false;
                    }
                }
                if (valueType == ValueType.VARIABLE) {
                    valueType = null;
                }
                if (valueType != null) {
                    if (parameterValue != null && !parameterValue.isArray() && '[' == cchar) {
                        throw this.syntaxError(line, tline, "Parameter value is not an array type");
                    }
                    if (valueType != ValueType.PARAMETERS && '{' == cchar) {
                        throw this.syntaxError(line, tline, parameterValue, valueType);
                    }
                    if (valueType != ValueType.TEXT && '(' == cchar) {
                        throw this.syntaxError(line, tline, parameterValue, valueType);
                    }
                }
            }
            if (parameterValue != null && !parameterValue.isArray()) {
                if (valueType == ValueType.PARAMETERS && '{' != cchar) {
                    throw this.syntaxError(line, tline, parameterValue, valueType);
                }
                if (valueType == ValueType.TEXT && !"null".equals(value) && '(' != cchar) {
                    throw this.syntaxError(line, tline, parameterValue, valueType);
                }
            }
            if ((parameterValue == null || parameterValue.isArray() || valueType == null) && '[' == cchar) {
                this.read(container, '[', name, parameterValue, valueType, valueTypeHinted);
                continue;
            }
            if (valueType == null) {
                if ('{' == cchar) {
                    valueType = ValueType.PARAMETERS;
                } else if ('(' == cchar) {
                    valueType = ValueType.TEXT;
                }
            }
            if (valueType == ValueType.PARAMETERS) {
                if (parameterValue == null) {
                    parameterValue = container.newParameterValue(name, valueType, openedBracket == '[');
                    parameterValue.setValueTypeHinted(valueTypeHinted);
                }
                Object ps = container.newParameters(name);
                this.read((Parameters)ps, '{', null, null, null, valueTypeHinted);
            } else if (valueType == ValueType.TEXT) {
                if (parameterValue == null) {
                    parameterValue = container.newParameterValue(name, valueType, openedBracket == '[');
                    parameterValue.setValueTypeHinted(valueTypeHinted);
                }
                if ('(' == cchar) {
                    parameterValue.putValue(this.readText());
                } else if ("null".equals(value)) {
                    parameterValue.putValue(null);
                } else {
                    parameterValue.putValue(value);
                }
            } else {
                if (vlen == 0) {
                    value = null;
                    if (valueType == null) {
                        valueType = ValueType.STRING;
                    }
                } else if (valueType == null) {
                    if ("null".equals(value)) {
                        value = null;
                        valueType = ValueType.STRING;
                    } else if ("true".equals(value) || "false".equals(value)) {
                        valueType = ValueType.BOOLEAN;
                    } else if (value.charAt(0) == '\"') {
                        if (vlen == 1 || value.charAt(vlen - 1) != '\"') {
                            throw this.syntaxError(line, tline, "Unclosed quotation mark after the character string " + value);
                        }
                        valueType = ValueType.STRING;
                    } else if (value.charAt(0) == '\'') {
                        if (vlen == 1 || value.charAt(vlen - 1) != '\'') {
                            throw this.syntaxError(line, tline, "Unclosed quotation mark after the character string " + value);
                        }
                        valueType = ValueType.STRING;
                    } else {
                        try {
                            Integer.parseInt(value);
                            valueType = ValueType.INT;
                        }
                        catch (NumberFormatException e1) {
                            try {
                                Long.parseLong(value);
                                valueType = ValueType.LONG;
                            }
                            catch (NumberFormatException e2) {
                                try {
                                    Float.parseFloat(value);
                                    valueType = ValueType.FLOAT;
                                }
                                catch (NumberFormatException e3) {
                                    try {
                                        Double.parseDouble(value);
                                        valueType = ValueType.DOUBLE;
                                    }
                                    catch (NumberFormatException e4) {
                                        valueType = ValueType.STRING;
                                    }
                                }
                            }
                        }
                    }
                } else if ("null".equals(value)) {
                    value = null;
                }
                if (parameterValue == null) {
                    parameterValue = container.newParameterValue(name, valueType, openedBracket == '[');
                    parameterValue.setValueTypeHinted(valueTypeHinted);
                } else if (parameterValue.getValueType() == ValueType.VARIABLE) {
                    parameterValue.setValueType(valueType);
                } else if (parameterValue.getValueType() != valueType) {
                    throw this.syntaxError(line, tline, parameterValue, parameterValue.getValueType());
                }
                if (value == null) {
                    parameterValue.putValue(null);
                } else if (valueType == ValueType.STRING) {
                    if (value.charAt(0) == '\"' || value.charAt(0) == '\'') {
                        value = this.unescape(value.substring(1, vlen - 1), line, tline);
                    }
                    parameterValue.putValue(value);
                } else if (valueType == ValueType.BOOLEAN) {
                    parameterValue.putValue(Boolean.valueOf(value));
                } else if (valueType == ValueType.INT) {
                    parameterValue.putValue(Integer.valueOf(value));
                } else if (valueType == ValueType.LONG) {
                    parameterValue.putValue(Long.valueOf(value));
                } else if (valueType == ValueType.FLOAT) {
                    parameterValue.putValue(Float.valueOf(value));
                } else if (valueType == ValueType.DOUBLE) {
                    parameterValue.putValue(Double.valueOf(value));
                }
            }
            if (!parameterValue.isArray() || !parameterValue.isBracketed() || openedBracket == '[') continue;
            parameterValue.setBracketed(false);
        }
        if (openedBracket == '{') {
            throw new MissingClosingBracketException("curly", name, parameterValue);
        }
        if (openedBracket == '[') {
            throw new MissingClosingBracketException("square", name, parameterValue);
        }
    }

    private String readText() throws IOException {
        String line;
        String tline = null;
        StringBuilder sb = null;
        while ((line = this.reader.readLine()) != null) {
            char tchar;
            ++this.lineNumber;
            tline = line.trim();
            int tlen = tline.length();
            char c = tchar = tlen > 0 ? tline.charAt(0) : (char)'\u0000';
            if (tlen == 1 && ')' == tchar) {
                return sb != null ? sb.toString() : "";
            }
            if ('|' == tchar) {
                String str;
                if (sb == null) {
                    sb = new StringBuilder();
                } else {
                    sb.append(SYSTEM_NEW_LINE);
                }
                if ((str = line.substring(line.indexOf(124) + 1)).length() <= 0) continue;
                sb.append(str);
                continue;
            }
            if (tlen <= 0) continue;
            throw this.syntaxError(line, tline, "The closing round bracket was missing or Each text line is must start with a '|'");
        }
        throw this.syntaxError("", tline, "The end of the text line was reached with no closing round bracket found");
    }

    private String unescape(String str, String line, String ltrim) throws IOException {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0 || str.indexOf(92) == -1) {
            return str;
        }
        StringBuilder sb = new StringBuilder(len);
        int pos = 0;
        block9: while (pos < len) {
            char c;
            if ((c = str.charAt(pos++)) == '\\') {
                if (pos >= len) {
                    throw this.syntaxError(line, ltrim, "Unterminated escape sequence");
                }
                c = str.charAt(pos++);
                switch (c) {
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        sb.append(c);
                        continue block9;
                    }
                    case 'b': {
                        sb.append('\b');
                        continue block9;
                    }
                    case 't': {
                        sb.append('\t');
                        continue block9;
                    }
                    case 'n': {
                        sb.append('\n');
                        continue block9;
                    }
                    case 'f': {
                        sb.append('\f');
                        continue block9;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block9;
                    }
                    case 'u': {
                        int i;
                        if (pos + 4 > len) {
                            throw this.syntaxError(line, ltrim, "Unterminated escape sequence");
                        }
                        char result = '\u0000';
                        int end = i + 4;
                        for (i = pos; i < end; ++i) {
                            c = str.charAt(i);
                            result = (char)(result << 4);
                            if (c >= '0' && c <= '9') {
                                result = (char)(result + (c - 48));
                                continue;
                            }
                            if (c >= 'a' && c <= 'f') {
                                result = (char)(result + (c - 97 + 10));
                                continue;
                            }
                            if (c >= 'A' && c <= 'F') {
                                result = (char)(result + (c - 65 + 10));
                                continue;
                            }
                            throw this.syntaxError(line, ltrim, "Invalid number format: \\u" + str.substring(pos, pos + 4));
                        }
                        pos = end;
                        sb.append(result);
                        continue block9;
                    }
                }
                throw this.syntaxError(line, ltrim, "Invalid escape sequence");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    private IOException syntaxError(String line, String tline, String message) throws IOException {
        throw new MalformedAponException(this.lineNumber, line, tline, message);
    }

    private IOException syntaxError(String line, String tline, ParameterValue parameterValue, ValueType expectedValueType) throws IOException {
        throw new MalformedAponException(this.lineNumber, line, tline, parameterValue, expectedValueType);
    }

    public static Parameters parse(String text) throws IOException {
        VariableParameters parameters = new VariableParameters();
        return AponReader.parse(text, parameters);
    }

    public static <T extends Parameters> T parse(String text, Class<T> requiredType) throws IOException {
        Parameters parameters = (Parameters)ClassUtils.createInstance(requiredType);
        return (T)AponReader.parse(text, parameters);
    }

    public static <T extends Parameters> T parse(String text, T parameters) throws IOException {
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        if (StringUtils.isEmpty(text)) {
            return parameters;
        }
        try {
            AponReader aponReader = new AponReader(text);
            aponReader.read(parameters);
            aponReader.close();
            return parameters;
        }
        catch (AponParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AponParseException("Failed to parse string with APON format", e);
        }
    }

    public static Parameters parse(File file) throws IOException {
        return AponReader.parse(file, (String)null);
    }

    public static Parameters parse(File file, String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        VariableParameters parameters = new VariableParameters();
        return AponReader.parse(file, encoding, parameters);
    }

    public static <T extends Parameters> T parse(File file, T parameters) throws IOException {
        return AponReader.parse(file, null, parameters);
    }

    public static <T extends Parameters> T parse(File file, String encoding, T parameters) throws IOException {
        T t;
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        AponReader aponReader = null;
        try {
            aponReader = encoding == null ? new AponReader(new FileReader(file)) : new AponReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
            t = aponReader.read(parameters);
        }
        catch (AponParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AponParseException("Failed to parse string with APON format", e);
        }
        finally {
            if (aponReader != null) {
                try {
                    aponReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return t;
    }

    public static Parameters parse(Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        AponReader aponReader = new AponReader(reader);
        return aponReader.read();
    }

    public static <T extends Parameters> T parse(Reader reader, T parameters) throws IOException {
        AponReader aponReader = new AponReader(reader);
        aponReader.read(parameters);
        return parameters;
    }
}

