/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.apon;

import com.aspectran.core.util.apon.Parameters;

public enum ValueType {
    STRING("string"),
    TEXT("text"),
    INT("int"),
    LONG("long"),
    FLOAT("float"),
    DOUBLE("double"),
    BOOLEAN("boolean"),
    OBJECT("object"),
    VARIABLE("variable"),
    PARAMETERS("parameters");

    private final String alias;

    private ValueType(String alias) {
        this.alias = alias;
    }

    public String toString() {
        return this.alias;
    }

    public static ValueType resolve(String alias) {
        for (ValueType type : ValueType.values()) {
            if (!type.alias.equals(alias)) continue;
            return type;
        }
        return null;
    }

    public static ValueType resolveByHint(String name) {
        int hintEndIndex;
        int hintStartIndex = name.indexOf(40);
        if (hintStartIndex > 0 && (hintEndIndex = name.indexOf(41)) > hintStartIndex) {
            String typeHint = name.substring(hintStartIndex + 1, hintEndIndex);
            return ValueType.resolve(typeHint);
        }
        return null;
    }

    public static String stripValueTypeHint(String name) {
        int hintStartIndex = name.indexOf(40);
        if (hintStartIndex > 0) {
            return name.substring(0, hintStartIndex);
        }
        return name;
    }

    public static ValueType determineValueType(Object value) {
        ValueType type = value instanceof CharSequence ? (value.toString().contains("\n") ? TEXT : STRING) : (value instanceof Character ? STRING : (value instanceof Integer ? INT : (value instanceof Long ? LONG : (value instanceof Float ? FLOAT : (value instanceof Double ? DOUBLE : (value instanceof Boolean ? BOOLEAN : (value instanceof Parameters ? PARAMETERS : OBJECT)))))));
        return type;
    }
}

