/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.cache;

import com.aspectran.core.util.Assert;
import com.aspectran.core.util.ConcurrentReferenceHashMap;
import com.aspectran.core.util.cache.Cache;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class ConcurrentReferenceCache<K, V>
implements Cache<K, V> {
    private final Map<K, V> cache;
    private final Function<K, V> generator;

    public ConcurrentReferenceCache(Function<K, V> generator) {
        Assert.notNull(generator, "Generator function must not be null");
        this.cache = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.SOFT);
        this.generator = generator;
    }

    public ConcurrentReferenceCache(ConcurrentReferenceHashMap.ReferenceType referenceType, Function<K, V> generator) {
        Assert.notNull((Object)referenceType, "Reference type must not be null");
        Assert.notNull(generator, "Generator function must not be null");
        this.cache = new ConcurrentReferenceHashMap(16, referenceType);
        this.generator = generator;
    }

    @Override
    public V get(K key) {
        V existing;
        V cached = this.cache.get(key);
        if (cached == null && (existing = this.cache.putIfAbsent(key, cached = this.generator.apply(key))) != null) {
            cached = existing;
        }
        return cached;
    }

    @Override
    public void remove(K key) {
        this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }
}

