/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.logging;

import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerException;
import com.aspectran.core.util.logging.commons.JakartaCommonsLogger;
import com.aspectran.core.util.logging.jdk14.Jdk14Logger;
import com.aspectran.core.util.logging.log4j.Log4jLogger;
import com.aspectran.core.util.logging.log4j2.Log4j2Logger;
import com.aspectran.core.util.logging.nologging.DumbLogger;
import com.aspectran.core.util.logging.slf4j.Slf4jLogger;
import com.aspectran.core.util.logging.stdout.StdOutLogger;
import java.lang.reflect.Constructor;

public final class LoggerFactory {
    public static final String MARKER = "ASPECTRAN";
    protected static final String EXCEPTION_MESSAGE = "Unexpected exception: ";
    private static Constructor<? extends Logger> loggerConstructor;

    private LoggerFactory() {
    }

    public static Logger getLogger(Class<?> aClass) {
        return LoggerFactory.getLogger(aClass.getName());
    }

    public static Logger getLogger(String name) {
        try {
            return loggerConstructor.newInstance(name);
        }
        catch (Throwable t) {
            throw new LoggerException("Error creating logger for " + name + ".  Cause: " + t, t);
        }
    }

    public static synchronized void useCustomLogging(Class<? extends Logger> clazz) {
        LoggerFactory.setImplementation(clazz);
    }

    public static synchronized void useSlf4jLogging() {
        LoggerFactory.setImplementation(Slf4jLogger.class);
    }

    public static synchronized void useCommonsLogging() {
        LoggerFactory.setImplementation(JakartaCommonsLogger.class);
    }

    public static synchronized void useLog4JLogging() {
        LoggerFactory.setImplementation(Log4jLogger.class);
    }

    public static synchronized void useLog4J2Logging() {
        LoggerFactory.setImplementation(Log4j2Logger.class);
    }

    public static synchronized void useJdkLogging() {
        LoggerFactory.setImplementation(Jdk14Logger.class);
    }

    public static synchronized void useStdOutLogging() {
        LoggerFactory.setImplementation(StdOutLogger.class);
    }

    public static synchronized void useNoLogging() {
        LoggerFactory.setImplementation(DumbLogger.class);
    }

    private static void tryImplementation(Runnable runnable) {
        if (loggerConstructor == null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void setImplementation(Class<? extends Logger> implClass) {
        try {
            Constructor<? extends Logger> candidate = implClass.getConstructor(String.class);
            Logger logger = candidate.newInstance(LoggerFactory.class.getName());
            if (logger.isDebugEnabled()) {
                logger.debug("Logging initialized using '" + implClass + "' adapter");
            }
            loggerConstructor = candidate;
        }
        catch (Throwable t) {
            throw new LoggerException("Error setting Logger implementation.  Cause: " + t, t);
        }
    }

    static {
        LoggerFactory.tryImplementation(LoggerFactory::useSlf4jLogging);
        LoggerFactory.tryImplementation(LoggerFactory::useCommonsLogging);
        LoggerFactory.tryImplementation(LoggerFactory::useLog4J2Logging);
        LoggerFactory.tryImplementation(LoggerFactory::useLog4JLogging);
        LoggerFactory.tryImplementation(LoggerFactory::useJdkLogging);
        LoggerFactory.tryImplementation(LoggerFactory::useNoLogging);
    }
}

