/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.logging.log4j2;

import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.log4j2.Log4j2Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;

public class Log4j2ExtendedLoggerWrapper
implements Logger {
    private static final Marker MARKER = MarkerManager.getMarker((String)"ASPECTRAN");
    private static final String FQCN = Log4j2Logger.class.getName();
    private final transient ExtendedLoggerWrapper internalLogger;

    public Log4j2ExtendedLoggerWrapper(ExtendedLogger extendedLogger) {
        this.internalLogger = new ExtendedLoggerWrapper(extendedLogger, extendedLogger.getName(), extendedLogger.getMessageFactory());
    }

    @Override
    public boolean isDebugEnabled() {
        return this.internalLogger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.internalLogger.isTraceEnabled();
    }

    @Override
    public void error(String s) {
        this.internalLogger.logIfEnabled(FQCN, Level.ERROR, MARKER, (Message)new SimpleMessage(s), null);
    }

    @Override
    public void error(String s, Throwable e) {
        this.internalLogger.logIfEnabled(FQCN, Level.ERROR, MARKER, (Message)new SimpleMessage(s), e);
    }

    @Override
    public void debug(String s) {
        this.internalLogger.logIfEnabled(FQCN, Level.DEBUG, MARKER, (Message)new SimpleMessage(s), null);
    }

    @Override
    public void debug(String s, Throwable e) {
        this.internalLogger.logIfEnabled(FQCN, Level.DEBUG, MARKER, (Message)new SimpleMessage(s), e);
    }

    @Override
    public void info(String s) {
        this.internalLogger.logIfEnabled(FQCN, Level.INFO, MARKER, (Message)new SimpleMessage(s), null);
    }

    @Override
    public void trace(String s) {
        this.internalLogger.logIfEnabled(FQCN, Level.TRACE, MARKER, (Message)new SimpleMessage(s), null);
    }

    @Override
    public void warn(String s) {
        this.internalLogger.logIfEnabled(FQCN, Level.WARN, MARKER, (Message)new SimpleMessage(s), null);
    }

    @Override
    public void warn(String s, Throwable e) {
        this.internalLogger.logIfEnabled(FQCN, Level.WARN, MARKER, (Message)new SimpleMessage(s), e);
    }
}

