/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.logging.slf4j;

import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.slf4j.Slf4jLogger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.spi.LocationAwareLogger;

class Slf4jLocationAwareLoggerWrapper
implements Logger {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"ASPECTRAN");
    private static final String FQCN = Slf4jLogger.class.getName();
    private final transient LocationAwareLogger internalLogger;

    Slf4jLocationAwareLoggerWrapper(LocationAwareLogger internalLogger) {
        this.internalLogger = internalLogger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.internalLogger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.internalLogger.isTraceEnabled();
    }

    @Override
    public void error(String s, Throwable e) {
        this.internalLogger.log(MARKER, FQCN, 40, s, null, e);
    }

    @Override
    public void error(String s) {
        this.internalLogger.log(MARKER, FQCN, 40, s, null, null);
    }

    @Override
    public void debug(String s) {
        this.internalLogger.log(MARKER, FQCN, 10, s, null, null);
    }

    @Override
    public void debug(String s, Throwable e) {
        this.internalLogger.log(MARKER, FQCN, 10, s, null, e);
    }

    @Override
    public void info(String s) {
        this.internalLogger.log(MARKER, FQCN, 20, s, null, null);
    }

    @Override
    public void trace(String s) {
        this.internalLogger.log(MARKER, FQCN, 0, s, null, null);
    }

    @Override
    public void warn(String s) {
        this.internalLogger.log(MARKER, FQCN, 30, s, null, null);
    }

    @Override
    public void warn(String s, Throwable e) {
        this.internalLogger.log(MARKER, FQCN, 30, s, null, e);
    }
}

