/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.statistic;

import com.aspectran.core.util.ToStringBuilder;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;

public class CounterStatistic {
    protected final LongAccumulator max = new LongAccumulator(Math::max, 0L);
    protected final AtomicLong current = new AtomicLong();
    protected final LongAdder total = new LongAdder();

    public void reset() {
        this.total.reset();
        this.max.reset();
        long current = this.current.get();
        this.total.add(current);
        this.max.accumulate(current);
    }

    public void reset(long value) {
        this.current.set(value);
        this.total.reset();
        this.max.reset();
        if (value > 0L) {
            this.total.add(value);
            this.max.accumulate(value);
        }
    }

    public long add(long delta) {
        long value = this.current.addAndGet(delta);
        if (delta > 0L) {
            this.total.add(delta);
            this.max.accumulate(value);
        }
        return value;
    }

    public long increment() {
        long value = this.current.incrementAndGet();
        this.total.increment();
        this.max.accumulate(value);
        return value;
    }

    public long decrement() {
        return this.current.decrementAndGet();
    }

    public long getMax() {
        return this.max.get();
    }

    public long getCurrent() {
        return this.current.get();
    }

    public long getTotal() {
        return this.total.sum();
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode()));
        tsb.append("current", this.current.get());
        tsb.append("max", this.max.get());
        tsb.append("total", this.total.sum());
        return tsb.toString();
    }
}

