/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon;

import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.DaemonConfig;
import com.aspectran.core.context.config.DaemonPollerConfig;
import com.aspectran.core.util.Aspectran;
import com.aspectran.core.util.apon.AponReader;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.daemon.Daemon;
import com.aspectran.daemon.command.CommandRegistry;
import com.aspectran.daemon.command.DaemonCommandRegistry;
import com.aspectran.daemon.command.builtins.QuitCommand;
import com.aspectran.daemon.command.polling.CommandPoller;
import com.aspectran.daemon.command.polling.FileCommandPoller;
import com.aspectran.daemon.service.AspectranDaemonService;
import com.aspectran.daemon.service.DaemonService;
import java.io.File;
import java.io.PrintStream;

public class AbstractDaemon
implements Daemon {
    private String name;
    private AspectranDaemonService service;
    private CommandPoller commandPoller;
    private CommandRegistry commandRegistry;
    private boolean wait;
    private Thread pollingThread;
    private volatile boolean active;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public DaemonService getService() {
        return this.service;
    }

    @Override
    public CommandPoller getCommandPoller() {
        return this.commandPoller;
    }

    @Override
    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    @Override
    public boolean isWait() {
        return this.wait;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    protected void init(String basePath, File aspectranConfigFile) throws Exception {
        AspectranConfig aspectranConfig = new AspectranConfig();
        try {
            AponReader.parse((File)aspectranConfigFile, (Parameters)aspectranConfig);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse aspectran config file: " + aspectranConfigFile, e);
        }
        if (basePath != null) {
            aspectranConfig.touchContextConfig().setBasePath(basePath);
        }
        this.init(aspectranConfig);
    }

    protected void init(AspectranConfig aspectranConfig) throws Exception {
        try {
            this.service = AspectranDaemonService.create(aspectranConfig);
            this.service.start();
        }
        catch (Exception e) {
            throw new Exception("Failed to initialize daemon", e);
        }
        this.init(aspectranConfig.touchDaemonConfig());
    }

    protected void init(DaemonConfig daemonConfig) throws Exception {
        Aspectran.printPrettyAboutMe((PrintStream)System.out);
        try {
            DaemonPollerConfig pollerConfig = daemonConfig.touchPollerConfig();
            this.commandPoller = new FileCommandPoller(this, pollerConfig);
            DaemonCommandRegistry commandRegistry = new DaemonCommandRegistry(this);
            commandRegistry.addCommand(daemonConfig.getCommands());
            if (commandRegistry.getCommand(QuitCommand.class) == null) {
                commandRegistry.addCommand(QuitCommand.class);
            }
            this.commandRegistry = commandRegistry;
        }
        catch (Exception e) {
            throw new Exception("Failed to initialize daemon", e);
        }
    }

    protected void start() throws Exception {
        this.start(false);
    }

    protected void start(boolean wait) throws Exception {
        if (wait) {
            this.start(0L);
        } else {
            this.start(-1L);
        }
    }

    protected void start(long wait) throws Exception {
        if (!this.active) {
            boolean bl = this.wait = wait >= 0L;
            if (this.name == null) {
                this.name = this.getClass().getSimpleName();
            }
            Runnable runnable = () -> {
                if (!this.active) {
                    this.active = true;
                    this.getCommandPoller().requeue();
                    while (this.active) {
                        try {
                            this.getCommandPoller().polling();
                            Thread.sleep(this.getCommandPoller().getPollingInterval());
                        }
                        catch (InterruptedException ie) {
                            this.active = false;
                        }
                    }
                }
            };
            this.pollingThread = new Thread(runnable, this.name);
            this.pollingThread.start();
            if (wait >= 0L) {
                this.pollingThread.join(wait);
            }
        }
    }

    @Override
    public void stop() {
        if (this.active) {
            this.active = false;
            if (this.pollingThread != null) {
                if (this.pollingThread.getState() == Thread.State.TIMED_WAITING) {
                    this.pollingThread.interrupt();
                }
                this.pollingThread = null;
            }
        }
    }

    @Override
    public void destroy() {
        this.stop();
        if (this.commandPoller != null) {
            this.commandPoller.stop();
            this.commandPoller = null;
        }
        if (this.service != null) {
            this.service.stop();
            this.service = null;
        }
    }
}

