/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.AdapterException;
import com.aspectran.core.activity.CoreActivity;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.adapter.BasicSessionAdapter;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.util.StringOutputWriter;
import com.aspectran.daemon.adapter.DaemonRequestAdapter;
import com.aspectran.daemon.adapter.DaemonResponseAdapter;
import com.aspectran.daemon.service.DaemonService;
import java.io.Writer;
import java.util.Map;

public class DaemonActivity
extends CoreActivity {
    private final DaemonService service;
    private Writer outputWriter;
    private ParameterMap parameterMap;
    private Map<String, Object> attributeMap;

    public DaemonActivity(DaemonService service) {
        super(service.getActivityContext());
        this.service = service;
    }

    public void setParameterMap(ParameterMap parameterMap) {
        this.parameterMap = parameterMap;
    }

    public void setAttributeMap(Map<String, Object> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public void setOutputWriter(Writer outputWriter) {
        this.outputWriter = outputWriter;
    }

    protected void adapt() throws AdapterException {
        try {
            if (this.getOuterActivity() == null) {
                this.setSessionAdapter(this.service.newSessionAdapter());
            } else {
                this.setSessionAdapter(this.getOuterActivity().getSessionAdapter());
            }
            DaemonRequestAdapter requestAdapter = new DaemonRequestAdapter(this.getTranslet().getRequestMethod());
            if (this.getOuterActivity() == null) {
                requestAdapter.preparse(this.attributeMap, this.parameterMap);
            } else {
                requestAdapter.preparse(this.getOuterActivity().getRequestAdapter());
            }
            this.setRequestAdapter((RequestAdapter)requestAdapter);
            if (this.outputWriter == null) {
                this.outputWriter = new StringOutputWriter();
            }
            DaemonResponseAdapter responseAdapter = new DaemonResponseAdapter(this.outputWriter);
            this.setResponseAdapter((ResponseAdapter)responseAdapter);
            super.adapt();
        }
        catch (Exception e) {
            throw new AdapterException("Failed to adapt for Daemon Activity", (Throwable)e);
        }
    }

    public void perform() {
        if (this.getOuterActivity() == null && this.getSessionAdapter() != null) {
            ((BasicSessionAdapter)this.getSessionAdapter()).getSessionAgent().access();
        }
        super.perform();
    }

    protected void release() {
        if (this.getOuterActivity() == null && this.getSessionAdapter() != null) {
            ((BasicSessionAdapter)this.getSessionAdapter()).getSessionAgent().complete();
        }
        super.release();
    }

    public <T extends Activity> T newActivity() {
        DaemonActivity activity = new DaemonActivity(this.service);
        activity.setOutputWriter(this.outputWriter);
        activity.setIncluded(true);
        return (T)((Object)activity);
    }
}

