/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command;

import com.aspectran.core.util.ExceptionUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.daemon.command.Command;
import com.aspectran.daemon.command.CommandRegistry;
import com.aspectran.daemon.command.CommandResult;
import com.aspectran.daemon.service.DaemonService;

public abstract class AbstractCommand
implements Command {
    private final Log log = LogFactory.getLog(this.getClass());
    private final CommandRegistry registry;
    private final boolean isolated;

    public AbstractCommand(CommandRegistry registry) {
        this(registry, false);
    }

    public AbstractCommand(CommandRegistry registry, boolean isolated) {
        this.registry = registry;
        this.isolated = isolated;
    }

    public CommandRegistry getCommandRegistry() {
        return this.registry;
    }

    @Override
    public boolean isIsolated() {
        return this.isolated;
    }

    public DaemonService getService() {
        DaemonService service = this.registry.getDaemon().getService();
        if (service == null || !service.getServiceController().isActive()) {
            throw new IllegalStateException("SERVICE NOT AVAILABLE");
        }
        return service;
    }

    protected String debug(String message) {
        this.log.debug(message);
        return message;
    }

    protected String info(String message) {
        this.log.info(message);
        return message;
    }

    protected String warn(String message) {
        this.log.warn(message);
        return message;
    }

    protected String error(String message) {
        this.log.error(message);
        return message;
    }

    protected CommandResult success(String message) {
        return new CommandResult(true, message);
    }

    protected CommandResult failed(String message) {
        return new CommandResult(false, message);
    }

    protected CommandResult failed(String message, Throwable throwable) {
        this.log.error(message, throwable);
        return new CommandResult(false, message + System.lineSeparator() + ExceptionUtils.getStacktrace((Throwable)throwable));
    }

    protected CommandResult failed(Throwable throwable) {
        this.log.error(throwable.getMessage(), throwable);
        return new CommandResult(false, ExceptionUtils.getStacktrace((Throwable)throwable));
    }
}

