/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command.builtins;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.InstantActivity;
import com.aspectran.core.activity.process.action.InvokeAction;
import com.aspectran.core.context.rule.InvokeActionRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.daemon.command.AbstractCommand;
import com.aspectran.daemon.command.Command;
import com.aspectran.daemon.command.CommandRegistry;
import com.aspectran.daemon.command.CommandResult;
import com.aspectran.daemon.command.polling.CommandParameters;
import com.aspectran.daemon.service.DaemonService;

public class InvokeActionCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "invokeAction";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public InvokeActionCommand(CommandRegistry registry) {
        super(registry);
    }

    @Override
    public CommandResult execute(CommandParameters parameters) {
        DaemonService service = this.getService();
        try {
            InstantActivity activity;
            InvokeAction invokeAction;
            Object result;
            String beanName = parameters.getBeanName();
            String methodName = parameters.getMethodName();
            ItemRuleMap argumentItemRuleMap = parameters.getArgumentItemRuleMap();
            ItemRuleMap propertyItemRuleMap = parameters.getPropertyItemRuleMap();
            if (beanName == null) {
                return this.failed(this.error("'bean' parameter is not specified"));
            }
            if (methodName == null) {
                return this.failed(this.error("'method' parameter is not specified"));
            }
            InvokeActionRule invokeActionRule = new InvokeActionRule();
            invokeActionRule.setBeanId(beanName);
            invokeActionRule.setMethodName(methodName);
            invokeActionRule.setArgumentItemRuleMap(argumentItemRuleMap);
            invokeActionRule.setPropertyItemRuleMap(propertyItemRuleMap);
            if (beanName.startsWith("class:")) {
                String className = beanName.substring("class:".length());
                Class beanClass = service.getAspectranClassLoader().loadClass(className);
                invokeActionRule.setBeanClass(beanClass);
            }
            return this.success((result = (invokeAction = new InvokeAction(invokeActionRule)).execute((Activity)(activity = new InstantActivity(service.getActivityContext())))) != null ? result.toString() : null);
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return InvokeActionCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return InvokeActionCommand.COMMAND_NAME;
        }

        @Override
        public String getDescription() {
            return "Executes a method on the specified bean";
        }
    }
}

