/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command.builtins;

import com.aspectran.core.context.expr.ItemExpression;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleList;
import com.aspectran.daemon.command.AbstractCommand;
import com.aspectran.daemon.command.Command;
import com.aspectran.daemon.command.CommandRegistry;
import com.aspectran.daemon.command.CommandResult;
import com.aspectran.daemon.command.polling.CommandParameters;
import com.aspectran.daemon.service.DaemonService;

public class PollingIntervalCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "pollingInterval";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public PollingIntervalCommand(CommandRegistry registry) {
        super(registry);
    }

    @Override
    public CommandResult execute(CommandParameters parameters) {
        DaemonService service = this.getService();
        try {
            long oldPollingInterval = this.getCommandRegistry().getDaemon().getCommandPoller().getPollingInterval();
            long pollingInterval = 0L;
            ItemRuleList itemRuleList = parameters.getArgumentItemRuleList();
            if (!itemRuleList.isEmpty()) {
                ItemExpression evaluator = new ItemExpression(service.getDefaultActivity());
                pollingInterval = (Long)evaluator.evaluate((ItemRule)itemRuleList.get(0));
            }
            if (pollingInterval > 0L) {
                this.getCommandRegistry().getDaemon().getCommandPoller().setPollingInterval(pollingInterval);
                return this.success(this.info("The polling interval is changed from " + oldPollingInterval + "ms to " + pollingInterval + " ms"));
            }
            if (pollingInterval < 0L) {
                return this.failed(this.error("The polling interval can not be negative: " + pollingInterval));
            }
            return this.failed(this.warn("The polling interval is not changed"));
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return PollingIntervalCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return PollingIntervalCommand.COMMAND_NAME;
        }

        @Override
        public String getDescription() {
            return "Specifies in seconds how often the daemon polls for new commands";
        }
    }
}

